/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.collision;

import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;

public class EntityCollisionObject {
    private final Vector axis;
    private final Polygon movable;
    private final Polygon fixed;
    private double penetrationDistance;
    private boolean seperated;
    private double[] playerMinMax;
    private double[] blockMinMax;
    private Vector entityVelocity;
    private boolean originallyCollided;
    private double velDot;

    public EntityCollisionObject(Polygon movable_, Polygon stationary, Vector axes, Vector entityVel) {
        this.axis = axes;
        this.movable = movable_;
        this.fixed = stationary;
        this.entityVelocity = entityVel;
        this.originallyCollided = false;
        this.generateCollision();
    }

    public void generateCollision() {
        double dot;
        this.velDot = -this.entityVelocity.dot(this.axis);
        double playerMin = dot = this.axis.dot(this.movable.getVertices()[0]);
        double playerMax = dot;
        for (int i = 1; i < this.movable.getVertices().length; ++i) {
            dot = this.axis.dot(this.movable.getVertices()[i]);
            if (dot < playerMin) {
                playerMin = dot;
            }
            if (!(dot > playerMax)) continue;
            playerMax = dot;
        }
        double blockMin = dot = this.axis.dot(this.fixed.getVertices()[0]);
        double blockMax = dot;
        for (int i = 1; i < this.fixed.getVertices().length; ++i) {
            dot = this.axis.dot(this.fixed.getVertices()[i]);
            if (dot < blockMin) {
                blockMin = dot;
            }
            if (!(dot > blockMax)) continue;
            blockMax = dot;
        }
        double movMaxFixMin = playerMin - blockMax;
        double movMinFixMax = playerMax - blockMin;
        boolean useDefault = true;
        if (movMaxFixMin > 0.0 || movMinFixMax < 0.0) {
            useDefault = false;
        } else {
            this.originallyCollided = true;
        }
        if (this.velDot > 0.0) {
            movMaxFixMin -= this.velDot;
        } else {
            movMinFixMax -= this.velDot;
        }
        if (movMaxFixMin > 0.0 || movMinFixMax < 0.0) {
            this.seperated = true;
            this.penetrationDistance = 0.0;
            return;
        }
        this.penetrationDistance = useDefault || this.velDot == 0.0 ? (Math.abs(movMaxFixMin) < Math.abs(movMinFixMax) ? movMaxFixMin : movMinFixMax) : (Math.signum(this.velDot) != Math.signum(movMinFixMax) ? movMinFixMax : movMaxFixMin);
        this.seperated = false;
    }

    public Vector getResponse() {
        return this.axis.getProduct(-this.penetrationDistance);
    }

    public Vector getCollisionNormal() {
        return this.axis;
    }

    public double getCollisionPenetrationDistance() {
        return this.penetrationDistance;
    }

    public boolean arePolygonsSeperated() {
        return this.seperated;
    }

    public boolean werePolygonsInitiallyColliding() {
        return this.originallyCollided;
    }

    public double getVelDot() {
        return this.velDot;
    }
}

