/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.collision;

import gnu.trove.TCollections;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.valkyrienskies.mod.common.math.RotationMatrices;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.multithreaded.PhysicsShipTransform;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import org.valkyrienskies.mod.common.physics.collision.CollisionInformationHolder;
import org.valkyrienskies.mod.common.physics.collision.optimization.IBitOctree;
import org.valkyrienskies.mod.common.physics.collision.optimization.IBitOctreeProvider;
import org.valkyrienskies.mod.common.physics.collision.optimization.ShipCollisionTask;
import org.valkyrienskies.mod.common.physics.collision.polygons.PhysCollisionObject;
import org.valkyrienskies.mod.common.physics.collision.polygons.PhysPolygonCollider;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;
import org.valkyrienskies.mod.common.physics.collision.polygons.PolygonCollisionPointFinder;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physmanagement.relocation.SpatialDetector;
import valkyrienwarfare.api.TransformType;

public class WorldPhysicsCollider {
    public static final double AABB_EXPANSION = 2.0;
    public static final double RANGE_CHECK = 1.8;
    public static final double AXIS_TOLERANCE = 0.3;
    public static final double CACHE_UPDATE_FREQUENCY = 0.075;
    public static final double COEFFICIENT_OF_RESTITUTION = 0.52;
    public static final double COLLISION_RANGE_CHECK = 0.65;
    public static final boolean USE_OCTREE_COLLISION = true;
    public static final double COLLISION_TASK_SHUFFLE_FREQUENCY = 0.5;
    public static final double KINETIC_FRICTION_COEFFICIENT = 0.15;
    private final BlockPos.MutableBlockPos mutablePos;
    private final Random rand;
    private final Collection<ShipCollisionTask> tasks;
    private final PhysicsCalculations calculator;
    private final World worldObj;
    private final PhysicsObject parent;
    private final TIntList cachedPotentialHits;
    private final TIntArrayList cachedHitsToRemove;
    private double ticksSinceCacheUpdate;
    private boolean updateCollisionTasksCache;
    private BlockPos centerPotentialHit;

    public WorldPhysicsCollider(PhysicsCalculations calculations) {
        this.calculator = calculations;
        this.parent = calculations.getParent();
        this.worldObj = this.parent.world();
        this.cachedPotentialHits = TCollections.synchronizedList((TIntList)new TIntArrayList());
        this.cachedHitsToRemove = new TIntArrayList();
        this.rand = new Random();
        this.mutablePos = new BlockPos.MutableBlockPos();
        this.tasks = new ArrayList<ShipCollisionTask>();
        this.ticksSinceCacheUpdate = 25.0;
        this.updateCollisionTasksCache = true;
        this.centerPotentialHit = null;
    }

    public void tickUpdatingTheCollisionCache() {
        this.ticksSinceCacheUpdate += this.calculator.getPhysicsTimeDeltaPerPhysTick();
        for (int i = 0; i < this.cachedHitsToRemove.size(); ++i) {
            this.cachedPotentialHits.remove(this.cachedHitsToRemove.get(i));
        }
        this.cachedHitsToRemove.resetQuick();
        if (this.ticksSinceCacheUpdate > 0.075 || this.parent.isNeedsCollisionCacheUpdate()) {
            this.updatePotentialCollisionCache();
            this.updateCollisionTasksCache = true;
        }
        if (Math.random() < 0.5) {
            this.cachedPotentialHits.shuffle(this.rand);
        }
    }

    public void splitIntoCollisionTasks(List<ShipCollisionTask> toAdd) {
        if (this.updateCollisionTasksCache) {
            this.tasks.clear();
            int size = this.cachedPotentialHits.size();
            for (int index = 0; index < size; index += 45) {
                ShipCollisionTask task = new ShipCollisionTask(this, index);
                this.tasks.add(task);
            }
            this.updateCollisionTasksCache = false;
        }
        toAdd.addAll(this.tasks);
    }

    public void processCollisionTask(ShipCollisionTask task) {
        BlockPos.MutableBlockPos inWorldPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos inLocalPos = new BlockPos.MutableBlockPos();
        Iterator<CollisionInformationHolder> collisionIterator = task.getCollisionInformationIterator();
        while (collisionIterator.hasNext()) {
            CollisionInformationHolder info = collisionIterator.next();
            inWorldPos.func_181079_c(info.inWorldX, info.inWorldY, info.inWorldZ);
            inLocalPos.func_181079_c(info.inLocalX, info.inLocalY, info.inLocalZ);
            this.handleActualCollision(info.collider, (BlockPos)inWorldPos, (BlockPos)inLocalPos, info.inWorldState, info.inLocalState);
        }
        task.getCollisionInformationGenerated().clear();
    }

    private void processPotentialCollisionsAccurately() {
        BlockPos.MutableBlockPos localCollisionPos = new BlockPos.MutableBlockPos();
        Vector inWorld = new Vector();
        TIntIterator cachedHitsIterator = this.cachedPotentialHits.iterator();
        block0: while (cachedHitsIterator.hasNext()) {
            SpatialDetector.setPosWithRespectTo(cachedHitsIterator.next(), this.centerPotentialHit, this.mutablePos);
            inWorld.X = (double)this.mutablePos.func_177958_n() + 0.5;
            inWorld.Y = (double)this.mutablePos.func_177956_o() + 0.5;
            inWorld.Z = (double)this.mutablePos.func_177952_p() + 0.5;
            this.parent.getShipTransformationManager().getCurrentPhysicsTransform().transform(inWorld, TransformType.GLOBAL_TO_SUBSPACE);
            int minX = MathHelper.func_76128_c((double)(inWorld.X - 0.65));
            int minY = MathHelper.func_76128_c((double)(inWorld.Y - 0.65));
            int minZ = MathHelper.func_76128_c((double)(inWorld.Z - 0.65));
            int maxX = MathHelper.func_76128_c((double)(inWorld.X + 0.65));
            int maxY = MathHelper.func_76128_c((double)(inWorld.Y + 0.65));
            int maxZ = MathHelper.func_76128_c((double)(inWorld.Z + 0.65));
            int minChunkX = minX >> 4;
            int minChunkY = minY >> 4;
            int minChunkZ = minZ >> 4;
            int maxChunkX = maxX >> 4;
            int maxChunkY = maxY >> 4;
            int maxChunkZ = maxZ >> 4;
            if (minChunkY > 15 || maxChunkY < 0) continue;
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    if (!this.parent.ownsChunk(chunkX, chunkZ)) continue;
                    Chunk chunkIn = this.parent.getChunkAt(chunkX, chunkZ);
                    int minXToCheck = chunkX << 4;
                    int maxXToCheck = minXToCheck + 15;
                    int minZToCheck = chunkZ << 4;
                    int maxZToCheck = minZToCheck + 15;
                    minXToCheck = Math.max(minXToCheck, minX);
                    maxXToCheck = Math.min(maxXToCheck, maxX);
                    minZToCheck = Math.max(minZToCheck, minZ);
                    maxZToCheck = Math.min(maxZToCheck, maxZ);
                    for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                        ExtendedBlockStorage storage = chunkIn.field_76652_q[chunkY];
                        if (storage == null) continue;
                        int minYToCheck = chunkY << 4;
                        int maxYToCheck = minYToCheck + 15;
                        minYToCheck = Math.max(minYToCheck, minY);
                        maxYToCheck = Math.min(maxYToCheck, maxY);
                        for (int x = minXToCheck; x <= maxXToCheck; ++x) {
                            for (int z = minZToCheck; z <= maxZToCheck; ++z) {
                                for (int y = minYToCheck; y <= maxYToCheck; ++y) {
                                    IBlockState state = storage.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
                                    if (!state.func_185904_a().func_76220_a()) continue;
                                    localCollisionPos.func_181079_c(x, y, z);
                                    boolean brokeAWorldBlock = this.handleLikelyCollision((BlockPos)this.mutablePos, (BlockPos)localCollisionPos, this.parent.getCachedSurroundingChunks().func_180495_p((BlockPos)this.mutablePos), state);
                                    if (!brokeAWorldBlock) continue;
                                    int positionRemoved = SpatialDetector.getHashWithRespectTo(this.mutablePos.func_177958_n(), this.mutablePos.func_177956_o(), this.mutablePos.func_177952_p(), this.centerPotentialHit);
                                    this.cachedHitsToRemove.add(positionRemoved);
                                    continue block0;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean handleLikelyCollision(BlockPos inWorldPos, BlockPos inLocalPos, IBlockState inWorldState, IBlockState inLocalState) {
        AxisAlignedBB inLocalBB = new AxisAlignedBB((double)inLocalPos.func_177958_n(), (double)inLocalPos.func_177956_o(), (double)inLocalPos.func_177952_p(), (double)(inLocalPos.func_177958_n() + 1), (double)(inLocalPos.func_177956_o() + 1), (double)(inLocalPos.func_177952_p() + 1));
        AxisAlignedBB inGlobalBB = new AxisAlignedBB((double)inWorldPos.func_177958_n(), (double)inWorldPos.func_177956_o(), (double)inWorldPos.func_177952_p(), (double)(inWorldPos.func_177958_n() + 1), (double)(inWorldPos.func_177956_o() + 1), (double)(inWorldPos.func_177952_p() + 1));
        Polygon shipInWorld = new Polygon(inLocalBB, this.parent.getShipTransformationManager().getCurrentPhysicsTransform(), TransformType.SUBSPACE_TO_GLOBAL);
        Polygon worldPoly = new Polygon(inGlobalBB);
        PhysPolygonCollider collider = new PhysPolygonCollider(shipInWorld, worldPoly, this.parent.getShipTransformationManager().normals);
        if (!collider.seperated) {
            return this.handleActualCollision(collider, inWorldPos, inLocalPos, inWorldState, inLocalState);
        }
        return false;
    }

    private boolean handleActualCollision(PhysPolygonCollider collider, BlockPos inWorldPos, BlockPos inLocalPos, IBlockState inWorldState, IBlockState inLocalState) {
        PhysCollisionObject toCollideWith = collider.collisions[1];
        if (toCollideWith.penetrationDistance > 0.3 || toCollideWith.penetrationDistance < -0.3) {
            toCollideWith = collider.collisions[collider.minDistanceIndex];
        }
        Vector positionInBody = collider.entity.getCenter();
        positionInBody.subtract(this.parent.getWrapperEntity().field_70165_t, this.parent.getWrapperEntity().field_70163_u, this.parent.getWrapperEntity().field_70161_v);
        double impulseApplied = 1.0;
        Vector[] collisionPoints = PolygonCollisionPointFinder.getPointsOfCollisionForPolygons(toCollideWith);
        impulseApplied /= (double)collisionPoints.length;
        for (Vector collisionPos : collisionPoints) {
            Vector inBody = collisionPos.getSubtraction(new Vector(this.parent.getWrapperEntity().field_70165_t, this.parent.getWrapperEntity().field_70163_u, this.parent.getWrapperEntity().field_70161_v));
            inBody.multiply(-1.0);
            Vector momentumAtPoint = this.calculator.getVelocityAtPoint(inBody);
            Vector axis = toCollideWith.collision_normal;
            Vector offsetVector = toCollideWith.getResponse();
            this.calculateCollisionImpulseForce(inBody, momentumAtPoint, axis, offsetVector, false, false, impulseApplied);
        }
        return false;
    }

    private void calculateCollisionImpulseForce(Vector inBody, Vector velocityAtPointOfCollision, Vector axis, Vector offsetVector, boolean didBlockBreakInShip, boolean didBlockBreakInWorld, double impulseApplied) {
        Vector collisionImpulseForce;
        Vector firstCross = inBody.cross(axis);
        RotationMatrices.applyTransform3by3(this.calculator.getPhysInvMOITensor(), firstCross);
        Vector secondCross = firstCross.cross(inBody);
        double impulseMagnitude = -velocityAtPointOfCollision.dot(axis) / (this.calculator.getInvMass() + secondCross.dot(axis));
        double slopR = 0.5;
        double collisionSpeed = Math.abs(velocityAtPointOfCollision.dot(axis));
        if (collisionSpeed > 0.5) {
            impulseMagnitude *= 1.52;
        }
        if ((collisionImpulseForce = new Vector(axis, impulseMagnitude)).dot(offsetVector) < 0.0 && collisionImpulseForce.dot(inBody) < 0.0) {
            double collisionVelocity = velocityAtPointOfCollision.dot(axis);
            this.addFrictionToNormalForce(velocityAtPointOfCollision, collisionImpulseForce, inBody);
            this.calculator.linearMomentum.add(collisionImpulseForce);
            Vector thirdCross = inBody.cross(collisionImpulseForce);
            RotationMatrices.applyTransform3by3(this.calculator.getPhysInvMOITensor(), thirdCross);
            this.calculator.angularVelocity.add(thirdCross);
        }
    }

    private void addFrictionToNormalForce(Vector momentumAtPoint, Vector impulseVector, Vector inBody) {
        double thirdCoefficient;
        Vector contactNormal = new Vector(impulseVector);
        contactNormal.normalize();
        Vector frictionVector = new Vector(momentumAtPoint);
        frictionVector.normalize();
        frictionVector.multiply(impulseVector.length() * 0.15);
        if (frictionVector.dot(momentumAtPoint) > 0.0) {
            frictionVector.multiply(-1.0);
        }
        double frictionImpulseDot = frictionVector.dot(contactNormal);
        Vector toRemove = contactNormal.getProduct(frictionImpulseDot);
        frictionVector.subtract(toRemove);
        double inertiaScalarAlongAxis = this.parent.getPhysicsProcessor().getInertiaAlongRotationAxis();
        Vector initialVelocity = new Vector(this.parent.getPhysicsProcessor().linearMomentum, this.parent.getPhysicsProcessor().getInvMass());
        Vector deltaVelocity = new Vector(frictionVector, this.parent.getPhysicsProcessor().getInvMass() * this.parent.getPhysicsProcessor().getDragForPhysTick());
        double A = initialVelocity.lengthSq();
        double B = 2.0 * initialVelocity.dot(deltaVelocity);
        double C = deltaVelocity.lengthSq();
        Vector initialAngularVelocity = this.parent.getPhysicsProcessor().angularVelocity;
        Vector deltaAngularVelocity = inBody.cross(frictionVector);
        deltaAngularVelocity.multiply(this.parent.getPhysicsProcessor().getDragForPhysTick() / inertiaScalarAlongAxis);
        double D = initialAngularVelocity.lengthSq();
        double E = 2.0 * deltaAngularVelocity.dot(initialAngularVelocity);
        double F = deltaAngularVelocity.lengthSq();
        if (initialAngularVelocity.lengthSq() < 0.05 && initialVelocity.lengthSq() < 0.05) {
            F = 0.0;
            E = 0.0;
            D = 0.0;
        }
        double firstCoefficient = A * this.parent.getPhysicsProcessor().getMass() + D * inertiaScalarAlongAxis;
        double secondCoefficient = B * this.parent.getPhysicsProcessor().getMass() + E * inertiaScalarAlongAxis;
        double scaleFactor = -secondCoefficient / ((thirdCoefficient = C * this.parent.getPhysicsProcessor().getMass() + F * inertiaScalarAlongAxis) * 2.0);
        if (new Double(scaleFactor).isNaN()) {
            scaleFactor = 0.0;
        } else {
            scaleFactor = Math.max(0.0, Math.min(scaleFactor, 1.0));
            frictionVector.multiply(scaleFactor);
        }
        impulseVector.add(frictionVector);
    }

    private void updatePotentialCollisionCache() {
        PhysicsShipTransform currentPhysicsTransform = (PhysicsShipTransform)this.parent.getShipTransformationManager().getCurrentPhysicsTransform();
        AxisAlignedBB collisionBB = currentPhysicsTransform.getShipBoundingBox().func_186662_g(3.0).func_186662_g(2.0).func_72321_a(this.calculator.linearMomentum.X * this.calculator.getInvMass() * this.calculator.getPhysicsTimeDeltaPerPhysTick() * 5.0, this.calculator.linearMomentum.Y * this.calculator.getInvMass() * this.calculator.getPhysicsTimeDeltaPerPhysTick() * 5.0, this.calculator.linearMomentum.Z * this.calculator.getInvMass() * this.calculator.getPhysicsTimeDeltaPerPhysTick() * 5.0);
        AxisAlignedBB shipBB = currentPhysicsTransform.getShipBoundingBox().func_186662_g(3.0);
        this.ticksSinceCacheUpdate = 0.0;
        if (Math.random() > 0.5) {
            this.ticksSinceCacheUpdate -= 0.05;
        }
        int oldSize = this.cachedPotentialHits.size();
        this.cachedPotentialHits.clear();
        if (collisionBB.field_72337_e < 0.0 || collisionBB.field_72338_b > 255.0) {
            return;
        }
        BlockPos min = new BlockPos(collisionBB.field_72340_a, Math.max(collisionBB.field_72338_b - 1.0, 0.0), collisionBB.field_72339_c);
        BlockPos max = new BlockPos(collisionBB.field_72336_d, Math.min(collisionBB.field_72337_e, 255.0), collisionBB.field_72334_f);
        this.centerPotentialHit = new BlockPos((double)(min.func_177958_n() + max.func_177958_n()) / 2.0, (double)(min.func_177956_o() + max.func_177956_o()) / 2.0, (double)(min.func_177952_p() + max.func_177952_p()) / 2.0);
        ChunkCache cache = this.parent.getCachedSurroundingChunks();
        if (cache == null) {
            System.err.println("VS Cached Surrounding Chunks was null! This is going to cause catastophric terrible events!!");
            return;
        }
        int chunkMinX = min.func_177958_n() >> 4;
        int chunkMaxX = (max.func_177958_n() >> 4) + 1;
        int chunkMinZ = min.func_177952_p() >> 4;
        int chunkMaxZ = (max.func_177952_p() >> 4) + 1;
        int minX = min.func_177958_n();
        int minY = min.func_177956_o();
        int minZ = min.func_177952_p();
        int maxX = max.func_177958_n();
        int maxY = max.func_177956_o();
        int maxZ = max.func_177952_p();
        if (this.parent.getBlockPositions().size() > 100) {
            ArrayList<Tuple> tasks = new ArrayList<Tuple>();
            for (int chunkX = chunkMinX; chunkX < chunkMaxX; ++chunkX) {
                for (int chunkZ = chunkMinZ; chunkZ < chunkMaxZ; ++chunkZ) {
                    tasks.add(new Tuple((Object)chunkX, (Object)chunkZ));
                }
            }
            Consumer<Tuple> consumer = i -> this.updateCollisionCacheSequential(cache, (Integer)i.func_76341_a(), (Integer)i.func_76340_b(), minX, minY, minZ, maxX, maxY, maxZ, shipBB);
            try {
                tasks.parallelStream().forEach(consumer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            double size = (double)(chunkMaxX - chunkMinX) * (double)(chunkMaxZ - chunkMinZ);
            if (size > 300000.0) {
                return;
            }
            for (int chunkX = chunkMinX; chunkX < chunkMaxX; ++chunkX) {
                for (int chunkZ = chunkMinZ; chunkZ < chunkMaxZ; ++chunkZ) {
                    this.updateCollisionCacheSequential(cache, chunkX, chunkZ, minX, minY, minZ, maxX, maxY, maxZ, shipBB);
                }
            }
        }
    }

    private void updateCollisionCacheParrallel(ChunkCache cache, Queue<Integer> dataQueue, int chunkX, int chunkZ, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int arrayChunkX = chunkX - cache.field_72818_a;
        int arrayChunkZ = chunkZ - cache.field_72816_b;
        if (cache.field_72817_c[arrayChunkX][arrayChunkZ] != null && arrayChunkX >= 0 && arrayChunkZ >= 0 && arrayChunkX <= cache.field_72817_c.length - 1 && arrayChunkZ <= cache.field_72817_c[0].length - 1) {
            Vector temp1 = new Vector();
            Vector temp2 = new Vector();
            Vector temp3 = new Vector();
            Chunk chunk = cache.field_72817_c[arrayChunkX][arrayChunkZ];
            for (int storageY = minY >> 4; storageY <= maxY >> 4; ++storageY) {
                ExtendedBlockStorage extendedblockstorage = chunk.field_76652_q[storageY];
                if (extendedblockstorage == null) continue;
                int minStorageX = chunkX << 4;
                int minStorageY = storageY << 4;
                int minStorageZ = chunkZ << 4;
                int maxStorageX = minStorageX + 16;
                int maxStorageY = minStorageY + 16;
                int maxStorageZ = minStorageZ + 16;
                IBitOctreeProvider provider = (IBitOctreeProvider)extendedblockstorage.field_177488_d;
                IBitOctree octree = provider.getBitOctree();
                for (int levelThree = 0; levelThree < 8; ++levelThree) {
                    int levelThreeIndex = octree.getOctreeLevelThreeIndex(levelThree);
                    if (!octree.getAtIndex(levelThreeIndex)) continue;
                    for (int levelTwo = 0; levelTwo < 8; ++levelTwo) {
                        int levelTwoIndex = octree.getOctreeLevelTwoIndex(levelThreeIndex, levelTwo);
                        if (!octree.getAtIndex(levelTwoIndex)) continue;
                        for (int levelOne = 0; levelOne < 8; ++levelOne) {
                            int levelOneIndex = octree.getOctreeLevelOneIndex(levelTwoIndex, levelOne);
                            if (!octree.getAtIndex(levelOneIndex)) continue;
                            int baseX = levelThree % 2 * 8 + levelTwo % 2 * 4 + levelOne % 2 * 2;
                            int baseY = (levelThree >> 1) % 2 * 8 + (levelTwo >> 1) % 2 * 4 + (levelOne >> 1) % 2 * 2;
                            int baseZ = (levelThree >> 2) % 2 * 8 + (levelTwo >> 2) % 2 * 4 + (levelOne >> 2) % 2 * 2;
                            int x = baseX + minStorageX;
                            int y = baseY + minStorageY;
                            int z = baseZ + minStorageZ;
                            dataQueue.add(0);
                            if (x >= minX && x <= maxX && y >= minY && y <= maxY && z >= minZ && z > maxZ) continue;
                        }
                    }
                }
            }
        }
    }

    private void updateCollisionCacheSequential(ChunkCache cache, int chunkX, int chunkZ, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, AxisAlignedBB shipBB) {
        int arrayChunkX = chunkX - cache.field_72818_a;
        int arrayChunkZ = chunkZ - cache.field_72816_b;
        if (arrayChunkX >= 0 && arrayChunkZ >= 0 && arrayChunkX <= cache.field_72817_c.length - 1 && arrayChunkZ <= cache.field_72817_c[0].length - 1 && cache.field_72817_c[arrayChunkX][arrayChunkZ] != null) {
            Vector temp1 = new Vector();
            Vector temp2 = new Vector();
            Vector temp3 = new Vector();
            Chunk chunk = cache.field_72817_c[arrayChunkX][arrayChunkZ];
            for (int storageY = minY >> 4; storageY <= maxY >> 4; ++storageY) {
                ExtendedBlockStorage extendedblockstorage = chunk.field_76652_q[storageY];
                if (extendedblockstorage == null) continue;
                int minStorageX = chunkX << 4;
                int minStorageY = storageY << 4;
                int minStorageZ = chunkZ << 4;
                int maxStorageX = minStorageX + 16;
                int maxStorageY = minStorageY + 16;
                int maxStorageZ = minStorageZ + 16;
                IBitOctreeProvider provider = (IBitOctreeProvider)extendedblockstorage.field_177488_d;
                IBitOctree octree = provider.getBitOctree();
                for (int levelThree = 0; levelThree < 8; ++levelThree) {
                    int levelThreeIndex = octree.getOctreeLevelThreeIndex(levelThree);
                    if (!octree.getAtIndex(levelThreeIndex)) continue;
                    for (int levelTwo = 0; levelTwo < 8; ++levelTwo) {
                        int levelTwoIndex = octree.getOctreeLevelTwoIndex(levelThreeIndex, levelTwo);
                        if (!octree.getAtIndex(levelTwoIndex)) continue;
                        for (int levelOne = 0; levelOne < 8; ++levelOne) {
                            int levelOneIndex = octree.getOctreeLevelOneIndex(levelTwoIndex, levelOne);
                            if (!octree.getAtIndex(levelOneIndex)) continue;
                            int baseX = levelThree % 2 * 8 + levelTwo % 2 * 4 + levelOne % 2 * 2;
                            int baseY = (levelThree >> 1) % 2 * 8 + (levelTwo >> 1) % 2 * 4 + (levelOne >> 1) % 2 * 2;
                            int baseZ = (levelThree >> 2) % 2 * 8 + (levelTwo >> 2) % 2 * 4 + (levelOne >> 2) % 2 * 2;
                            int x = baseX + minStorageX;
                            int y = baseY + minStorageY;
                            int z = baseZ + minStorageZ;
                            if (x < minX || x > maxX || y < minY || y > maxY || z < minZ || z > maxZ) continue;
                            this.checkForCollision(x, y, z, extendedblockstorage, octree, temp1, temp2, temp3, shipBB);
                            this.checkForCollision(x, y, z + 1, extendedblockstorage, octree, temp1, temp2, temp3, shipBB);
                            this.checkForCollision(x, y + 1, z, extendedblockstorage, octree, temp1, temp2, temp3, shipBB);
                            this.checkForCollision(x, y + 1, z + 1, extendedblockstorage, octree, temp1, temp2, temp3, shipBB);
                            this.checkForCollision(x + 1, y, z, extendedblockstorage, octree, temp1, temp2, temp3, shipBB);
                            this.checkForCollision(x + 1, y, z + 1, extendedblockstorage, octree, temp1, temp2, temp3, shipBB);
                            this.checkForCollision(x + 1, y + 1, z, extendedblockstorage, octree, temp1, temp2, temp3, shipBB);
                            this.checkForCollision(x + 1, y + 1, z + 1, extendedblockstorage, octree, temp1, temp2, temp3, shipBB);
                        }
                    }
                }
            }
        }
    }

    private void checkForCollision(int x, int y, int z, ExtendedBlockStorage storage, IBitOctree octree, Vector inLocal, Vector inBody, Vector speedInBody, AxisAlignedBB shipBB) {
        if (octree.get(x & 0xF, y & 0xF, z & 0xF)) {
            inLocal.X = (double)x + 0.5;
            inLocal.Y = (double)y + 0.5;
            inLocal.Z = (double)z + 0.5;
            if (inLocal.X > shipBB.field_72340_a && inLocal.X < shipBB.field_72336_d && inLocal.Y > shipBB.field_72338_b && inLocal.Y < shipBB.field_72337_e && inLocal.Z > shipBB.field_72339_c && inLocal.Z < shipBB.field_72334_f) {
                int maxZ;
                int minZ;
                int maxY;
                int minY;
                int maxX;
                int minX;
                this.parent.getShipTransformationManager().getCurrentPhysicsTransform().transform(inLocal, TransformType.GLOBAL_TO_SUBSPACE);
                inBody.setSubtraction(inLocal, this.parent.getCenterCoord());
                speedInBody.zero();
                if (speedInBody.X > 0.0) {
                    minX = MathHelper.func_76128_c((double)(inLocal.X - 1.8));
                    maxX = MathHelper.func_76128_c((double)(inLocal.X + 1.8 + speedInBody.X));
                } else {
                    minX = MathHelper.func_76128_c((double)(inLocal.X - 1.8 + speedInBody.X));
                    maxX = MathHelper.func_76128_c((double)(inLocal.X + 1.8));
                }
                if (speedInBody.Y > 0.0) {
                    minY = MathHelper.func_76128_c((double)(inLocal.Y - 1.8));
                    maxY = MathHelper.func_76128_c((double)(inLocal.Y + 1.8 + speedInBody.Y));
                } else {
                    minY = MathHelper.func_76128_c((double)(inLocal.Y - 1.8 + speedInBody.Y));
                    maxY = MathHelper.func_76128_c((double)(inLocal.Y + 1.8));
                }
                if (speedInBody.Z > 0.0) {
                    minZ = MathHelper.func_76128_c((double)(inLocal.Z - 1.8));
                    maxZ = MathHelper.func_76128_c((double)(inLocal.Z + 1.8 + speedInBody.Z));
                } else {
                    minZ = MathHelper.func_76128_c((double)(inLocal.Z - 1.8 + speedInBody.Z));
                    maxZ = MathHelper.func_76128_c((double)(inLocal.Z + 1.8));
                }
                minY = Math.min(255, Math.max(minY, 0));
                maxY = Math.min(255, Math.max(maxY, 0));
                if (this.parent.ownsChunk(minX >> 4, minZ >> 4) && this.parent.ownsChunk(maxX >> 4, maxZ >> 4)) {
                    Chunk chunkIn00 = this.parent.getChunkAt(minX >> 4, minZ >> 4);
                    Chunk chunkIn01 = this.parent.getChunkAt(minX >> 4, maxZ >> 4);
                    Chunk chunkIn10 = this.parent.getChunkAt(maxX >> 4, minZ >> 4);
                    Chunk chunkIn11 = this.parent.getChunkAt(maxX >> 4, maxZ >> 4);
                    block0: for (int localX = minX; localX < maxX; ++localX) {
                        for (int localZ = minZ; localZ < maxZ; ++localZ) {
                            Chunk theChunk = null;
                            theChunk = localX >> 4 == minX >> 4 ? (localZ >> 4 == minZ >> 4 ? chunkIn00 : chunkIn01) : (localZ >> 4 == minZ >> 4 ? chunkIn10 : chunkIn11);
                            for (int localY = minY; localY < maxY; ++localY) {
                                boolean result = this.checkForCollisionFast(theChunk, localX, localY, localZ, x, y, z);
                                if (result) break block0;
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean checkForCollisionFast(Chunk chunk, int localX, int localY, int localZ, int x, int y, int z) {
        IBitOctreeProvider provider;
        IBitOctree octreeInLocal;
        if (chunk.field_76652_q[localY >> 4] != null && (octreeInLocal = (provider = (IBitOctreeProvider)chunk.field_76652_q[localY >> 4].func_186049_g()).getBitOctree()).get(localX & 0xF, localY & 0xF, localZ & 0xF)) {
            int hash = SpatialDetector.getHashWithRespectTo(x, y, z, this.centerPotentialHit);
            try {
                this.cachedPotentialHits.add(hash);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void checkForCollision(int x, int y, int z, ExtendedBlockStorage storage, IBitOctree octree, Vector inLocal, Vector inBody, Vector speedInBody, Collection<Integer> collection) {
        if (octree.get(x & 0xF, y & 0xF, z & 0xF)) {
            int maxZ;
            int minZ;
            int maxY;
            int minY;
            int maxX;
            int minX;
            inLocal.X = (double)x + 0.5;
            inLocal.Y = (double)y + 0.5;
            inLocal.Z = (double)z + 0.5;
            this.parent.getShipTransformationManager().getCurrentPhysicsTransform().transform(inLocal, TransformType.GLOBAL_TO_SUBSPACE);
            inBody.setSubtraction(inLocal, this.parent.getCenterCoord());
            speedInBody.zero();
            double RANGE_CHECK = 1.8;
            if (speedInBody.X > 0.0) {
                minX = MathHelper.func_76128_c((double)(inLocal.X - RANGE_CHECK));
                maxX = MathHelper.func_76128_c((double)(inLocal.X + RANGE_CHECK + speedInBody.X));
            } else {
                minX = MathHelper.func_76128_c((double)(inLocal.X - RANGE_CHECK + speedInBody.X));
                maxX = MathHelper.func_76128_c((double)(inLocal.X + RANGE_CHECK));
            }
            if (speedInBody.Y > 0.0) {
                minY = MathHelper.func_76128_c((double)(inLocal.Y - RANGE_CHECK));
                maxY = MathHelper.func_76128_c((double)(inLocal.Y + RANGE_CHECK + speedInBody.Y));
            } else {
                minY = MathHelper.func_76128_c((double)(inLocal.Y - RANGE_CHECK + speedInBody.Y));
                maxY = MathHelper.func_76128_c((double)(inLocal.Y + RANGE_CHECK));
            }
            if (speedInBody.Z > 0.0) {
                minZ = MathHelper.func_76128_c((double)(inLocal.Z - RANGE_CHECK));
                maxZ = MathHelper.func_76128_c((double)(inLocal.Z + RANGE_CHECK + speedInBody.Z));
            } else {
                minZ = MathHelper.func_76128_c((double)(inLocal.Z - RANGE_CHECK + speedInBody.Z));
                maxZ = MathHelper.func_76128_c((double)(inLocal.Z + RANGE_CHECK));
            }
            minY = Math.min(255, Math.max(minY, 0));
            block0: for (int localX = minX; localX < maxX; ++localX) {
                for (int localZ = minZ; localZ < maxZ; ++localZ) {
                    for (int localY = minY; localY < maxY; ++localY) {
                        IBitOctreeProvider provider;
                        IBitOctree octreeInLocal;
                        if (!this.parent.ownsChunk(localX >> 4, localZ >> 4)) continue;
                        Chunk chunkIn = this.parent.getChunkAt(localX >> 4, localZ >> 4);
                        if (localY >> 4 >= 16 || chunkIn.field_76652_q[localY >> 4] == null || !(octreeInLocal = (provider = (IBitOctreeProvider)chunkIn.field_76652_q[localY >> 4].func_186049_g()).getBitOctree()).get(localX & 0xF, localY & 0xF, localZ & 0xF)) continue;
                        int hash = SpatialDetector.getHashWithRespectTo(x, y, z, this.centerPotentialHit);
                        collection.add(hash);
                        break block0;
                    }
                }
            }
        }
    }

    public BlockPos getCenterPotentialHit() {
        return this.centerPotentialHit;
    }

    public int getCachedPotentialHit(int offset) {
        return this.cachedPotentialHits.get(offset);
    }

    public int getCachedPotentialHitSize() {
        return this.cachedPotentialHits.size();
    }

    public PhysicsObject getParent() {
        return this.parent;
    }
}

