/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.collision.meshing;

import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import org.valkyrienskies.mod.common.physics.collision.meshing.IVoxelFieldAABBMaker;

public class NaiveVoxelFieldAABBMaker
implements IVoxelFieldAABBMaker {
    private final BlockPos centerPos;
    private final TreeMap<Integer, TreeSet<TwoInts>> xMap;
    private final TreeMap<Integer, TreeSet<TwoInts>> yMap;
    private final TreeMap<Integer, TreeSet<TwoInts>> zMap;
    private BlockPos minCoords;
    private BlockPos maxCoords;
    private int voxelCount;

    public NaiveVoxelFieldAABBMaker(int x, int z) {
        this.centerPos = new BlockPos(x, 0, z);
        this.xMap = new TreeMap();
        this.yMap = new TreeMap();
        this.zMap = new TreeMap();
        this.minCoords = null;
        this.maxCoords = null;
        this.voxelCount = 0;
    }

    @Override
    public AxisAlignedBB makeVoxelFieldAABB() {
        if (this.voxelCount == 0) {
            return null;
        }
        AxisAlignedBB inLocal = new AxisAlignedBB(this.minCoords, this.maxCoords);
        return inLocal.func_186670_a(this.centerPos);
    }

    @Override
    public boolean addVoxel(int x, int y, int z) {
        this.assertValidInputs(x -= this.centerPos.func_177958_n(), y -= this.centerPos.func_177956_o(), z -= this.centerPos.func_177952_p());
        boolean isVoxelNew = false;
        if (!this.xMap.containsKey(x)) {
            this.xMap.put(x, new TreeSet());
        }
        TwoInts yz = new TwoInts(y, z);
        if (this.xMap.get(x).add(yz)) {
            isVoxelNew = true;
        }
        if (!this.yMap.containsKey(y)) {
            this.yMap.put(y, new TreeSet());
        }
        TwoInts xz = new TwoInts(x, z);
        if (this.yMap.get(y).add(xz)) {
            isVoxelNew = true;
        }
        if (!this.zMap.containsKey(z)) {
            this.zMap.put(z, new TreeSet());
        }
        TwoInts xy = new TwoInts(x, y);
        if (this.zMap.get(z).add(xy)) {
            isVoxelNew = true;
        }
        if (!isVoxelNew) {
            return false;
        }
        ++this.voxelCount;
        if (this.minCoords == null || this.maxCoords == null) {
            this.minCoords = new BlockPos(x, y, z);
            this.maxCoords = new BlockPos(x, y, z);
            return true;
        }
        if (x > this.maxCoords.func_177958_n() || y > this.maxCoords.func_177956_o() || z > this.maxCoords.func_177952_p()) {
            this.maxCoords = new BlockPos(Math.max(x, this.maxCoords.func_177958_n()), Math.max(y, this.maxCoords.func_177956_o()), Math.max(z, this.maxCoords.func_177952_p()));
        }
        if (x < this.minCoords.func_177958_n() || y < this.minCoords.func_177956_o() || z < this.minCoords.func_177952_p()) {
            this.minCoords = new BlockPos(Math.min(x, this.minCoords.func_177958_n()), Math.min(y, this.minCoords.func_177956_o()), Math.min(z, this.minCoords.func_177952_p()));
        }
        return true;
    }

    @Override
    public boolean removeVoxel(int x, int y, int z) {
        int i;
        this.assertValidInputs(x -= this.centerPos.func_177958_n(), y -= this.centerPos.func_177956_o(), z -= this.centerPos.func_177952_p());
        boolean isVoxelRemoved = false;
        if (!this.xMap.containsKey(x)) {
            this.xMap.put(x, new TreeSet());
        }
        TwoInts yz = new TwoInts(y, z);
        if (this.xMap.get(x).remove(yz)) {
            isVoxelRemoved = true;
        }
        if (!this.yMap.containsKey(y)) {
            this.yMap.put(y, new TreeSet());
        }
        TwoInts xz = new TwoInts(x, z);
        if (this.yMap.get(y).remove(xz)) {
            isVoxelRemoved = true;
        }
        if (!this.zMap.containsKey(z)) {
            this.zMap.put(z, new TreeSet());
        }
        TwoInts xy = new TwoInts(x, y);
        if (this.zMap.get(z).remove(xy)) {
            isVoxelRemoved = true;
        }
        if (!isVoxelRemoved) {
            return false;
        }
        --this.voxelCount;
        if (x == this.maxCoords.func_177958_n() || y == this.maxCoords.func_177956_o() || z == this.maxCoords.func_177952_p()) {
            int newMaxX = this.maxCoords.func_177958_n();
            int newMaxY = this.maxCoords.func_177956_o();
            int newMaxZ = this.maxCoords.func_177952_p();
            if (x == this.maxCoords.func_177958_n()) {
                for (i = newMaxX; i >= -512; --i) {
                    if (!this.xMap.containsKey(i) || this.xMap.get(i).isEmpty()) continue;
                    newMaxX = i;
                    break;
                }
            }
            if (y == this.maxCoords.func_177956_o()) {
                for (i = newMaxY; i >= 0; --i) {
                    if (!this.yMap.containsKey(i) || this.yMap.get(i).isEmpty()) continue;
                    newMaxY = i;
                    break;
                }
            }
            if (z == this.maxCoords.func_177952_p()) {
                for (i = newMaxZ; i >= -512; --i) {
                    if (!this.zMap.containsKey(i) || this.zMap.get(i).isEmpty()) continue;
                    newMaxZ = i;
                    break;
                }
            }
            this.maxCoords = new BlockPos(newMaxX, newMaxY, newMaxZ);
        }
        if (x == this.minCoords.func_177958_n() || y == this.minCoords.func_177956_o() || z == this.minCoords.func_177952_p()) {
            int newMinX = this.minCoords.func_177958_n();
            int newMinY = this.minCoords.func_177956_o();
            int newMinZ = this.minCoords.func_177952_p();
            if (x == this.minCoords.func_177958_n()) {
                for (i = newMinX; i <= 511; ++i) {
                    if (!this.xMap.containsKey(i) || this.xMap.get(i).isEmpty()) continue;
                    newMinX = i;
                    break;
                }
            }
            if (y == this.minCoords.func_177956_o()) {
                for (i = newMinY; i <= 255; ++i) {
                    if (!this.yMap.containsKey(i) || this.yMap.get(i).isEmpty()) continue;
                    newMinY = i;
                    break;
                }
            }
            if (z == this.minCoords.func_177952_p()) {
                for (i = newMinZ; i <= 511; ++i) {
                    if (!this.zMap.containsKey(i) || this.zMap.get(i).isEmpty()) continue;
                    newMinZ = i;
                    break;
                }
            }
            this.minCoords = new BlockPos(newMinX, newMinY, newMinZ);
        }
        return true;
    }

    @Override
    public BlockPos getFieldCenter() {
        return this.centerPos;
    }

    private void assertValidInputs(int x, int y, int z) throws IllegalArgumentException {
        if (x < -512 || x > 511 || y < 0 || y > 255 || z < -512 || z > 511) {
            throw new IllegalArgumentException(x + ":" + y + ":" + z + " is out of range from " + this.getFieldCenter());
        }
    }

    private static class TwoInts
    implements Comparable<TwoInts> {
        final int first;
        final int second;

        TwoInts(int first, int second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public int compareTo(TwoInts other) {
            if (this.first != other.first) {
                return this.first - other.first;
            }
            return this.second - other.second;
        }

        public boolean equals(Object other) {
            if (!(other instanceof TwoInts)) {
                return false;
            }
            TwoInts otherInts = (TwoInts)other;
            return this.first == otherInts.first && this.second == otherInts.second;
        }

        public int hashCode() {
            return this.first + 512 << 14 | this.second + 512;
        }
    }
}

