/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.collision.optimization;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.collision.CollisionInformationHolder;
import org.valkyrienskies.mod.common.physics.collision.WorldPhysicsCollider;
import org.valkyrienskies.mod.common.physics.collision.optimization.IBitOctree;
import org.valkyrienskies.mod.common.physics.collision.optimization.IBitOctreeProvider;
import org.valkyrienskies.mod.common.physics.collision.polygons.PhysPolygonCollider;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;
import org.valkyrienskies.mod.common.physmanagement.relocation.SpatialDetector;
import valkyrienwarfare.api.TransformType;

public class ShipCollisionTask
implements Callable<Void> {
    public static final int MAX_TASKS_TO_CHECK = 45;
    private final WorldPhysicsCollider toTask;
    private final int taskStartIndex;
    private final int tasksToCheck;
    private final BlockPos.MutableBlockPos mutablePos;
    private final BlockPos.MutableBlockPos inLocalPos;
    private final Vector inWorld;
    private final List<CollisionInformationHolder> collisionInformationGenerated;
    private IBlockState inWorldState;

    public ShipCollisionTask(WorldPhysicsCollider toTask, int taskStartIndex) {
        this.taskStartIndex = taskStartIndex;
        this.toTask = toTask;
        this.mutablePos = new BlockPos.MutableBlockPos();
        this.inLocalPos = new BlockPos.MutableBlockPos();
        this.inWorld = new Vector();
        this.collisionInformationGenerated = new ArrayList<CollisionInformationHolder>();
        this.inWorldState = null;
        int size = toTask.getCachedPotentialHitSize();
        this.tasksToCheck = taskStartIndex + 45 > size + 1 ? size + 1 - taskStartIndex : 45;
    }

    @Override
    public Void call() {
        for (int index = this.taskStartIndex; index < this.tasksToCheck + 1; ++index) {
            int integer = this.toTask.getCachedPotentialHit(index);
            this.processNumber(integer);
        }
        return null;
    }

    public List<CollisionInformationHolder> getCollisionInformationGenerated() {
        return this.collisionInformationGenerated;
    }

    public Iterator<CollisionInformationHolder> getCollisionInformationIterator() {
        return this.collisionInformationGenerated.iterator();
    }

    private void processNumber(int integer) {
        SpatialDetector.setPosWithRespectTo(integer, this.toTask.getCenterPotentialHit(), this.mutablePos);
        this.inWorldState = this.toTask.getParent().getCachedSurroundingChunks().func_180495_p((BlockPos)this.mutablePos);
        this.inWorld.X = (double)this.mutablePos.func_177958_n() + 0.5;
        this.inWorld.Y = (double)this.mutablePos.func_177956_o() + 0.5;
        this.inWorld.Z = (double)this.mutablePos.func_177952_p() + 0.5;
        this.toTask.getParent().getShipTransformationManager().getCurrentPhysicsTransform().transform(this.inWorld, TransformType.GLOBAL_TO_SUBSPACE);
        int midX = MathHelper.func_76128_c((double)(this.inWorld.X + 0.5));
        int midY = MathHelper.func_76128_c((double)(this.inWorld.Y + 0.5));
        int midZ = MathHelper.func_76128_c((double)(this.inWorld.Z + 0.5));
        this.checkPosition(midX - 1, midY - 1, midZ - 1, integer);
        this.checkPosition(midX - 1, midY - 1, midZ, integer);
        this.checkPosition(midX - 1, midY - 1, midZ + 1, integer);
        this.checkPosition(midX - 1, midY, midZ - 1, integer);
        this.checkPosition(midX - 1, midY, midZ, integer);
        this.checkPosition(midX - 1, midY, midZ + 1, integer);
        this.checkPosition(midX - 1, midY + 1, midZ - 1, integer);
        this.checkPosition(midX - 1, midY + 1, midZ, integer);
        this.checkPosition(midX - 1, midY + 1, midZ + 1, integer);
        this.checkPosition(midX, midY - 1, midZ - 1, integer);
        this.checkPosition(midX, midY - 1, midZ, integer);
        this.checkPosition(midX, midY - 1, midZ + 1, integer);
        this.checkPosition(midX, midY, midZ - 1, integer);
        this.checkPosition(midX, midY, midZ, integer);
        this.checkPosition(midX, midY, midZ + 1, integer);
        this.checkPosition(midX, midY + 1, midZ - 1, integer);
        this.checkPosition(midX, midY + 1, midZ, integer);
        this.checkPosition(midX, midY + 1, midZ + 1, integer);
        this.checkPosition(midX + 1, midY - 1, midZ - 1, integer);
        this.checkPosition(midX + 1, midY - 1, midZ, integer);
        this.checkPosition(midX + 1, midY - 1, midZ + 1, integer);
        this.checkPosition(midX + 1, midY, midZ - 1, integer);
        this.checkPosition(midX + 1, midY, midZ, integer);
        this.checkPosition(midX + 1, midY, midZ + 1, integer);
        this.checkPosition(midX + 1, midY + 1, midZ - 1, integer);
        this.checkPosition(midX + 1, midY + 1, midZ, integer);
        this.checkPosition(midX + 1, midY + 1, midZ + 1, integer);
    }

    public void checkPosition(int x, int y, int z, int positionHash) {
        IBitOctreeProvider provider;
        IBitOctree octree;
        Chunk chunkIn = this.toTask.getParent().getChunkAt(x >> 4, z >> 4);
        ExtendedBlockStorage storage = chunkIn.field_76652_q[(y = Math.max(0, Math.min(y, 255))) >> 4];
        if (storage != null && (octree = (provider = (IBitOctreeProvider)storage.field_177488_d).getBitOctree()).get(x & 0xF, y & 0xF, z & 0xF)) {
            IBlockState inLocalState = chunkIn.func_186032_a(x, y, z);
            this.inLocalPos.func_181079_c(x, y, z);
            AxisAlignedBB inLocalBB = new AxisAlignedBB((double)this.inLocalPos.func_177958_n(), (double)this.inLocalPos.func_177956_o(), (double)this.inLocalPos.func_177952_p(), (double)(this.inLocalPos.func_177958_n() + 1), (double)(this.inLocalPos.func_177956_o() + 1), (double)(this.inLocalPos.func_177952_p() + 1));
            AxisAlignedBB inGlobalBB = new AxisAlignedBB((double)this.mutablePos.func_177958_n(), (double)this.mutablePos.func_177956_o(), (double)this.mutablePos.func_177952_p(), (double)(this.mutablePos.func_177958_n() + 1), (double)(this.mutablePos.func_177956_o() + 1), (double)(this.mutablePos.func_177952_p() + 1));
            Polygon shipInWorld = new Polygon(inLocalBB, this.toTask.getParent().getShipTransformationManager().getCurrentPhysicsTransform(), TransformType.SUBSPACE_TO_GLOBAL);
            Polygon worldPoly = new Polygon(inGlobalBB);
            PhysPolygonCollider collider = new PhysPolygonCollider(shipInWorld, worldPoly, this.toTask.getParent().getShipTransformationManager().normals);
            if (!collider.seperated) {
                CollisionInformationHolder holder = new CollisionInformationHolder(collider, this.mutablePos.func_177958_n(), this.mutablePos.func_177956_o(), this.mutablePos.func_177952_p(), this.inLocalPos.func_177958_n(), this.inLocalPos.func_177956_o(), this.inLocalPos.func_177952_p(), this.inWorldState, inLocalState);
                this.collisionInformationGenerated.add(holder);
            }
        }
    }

    public WorldPhysicsCollider getToTask() {
        return this.toTask;
    }

    private static class QuasiRandomIterator<E>
    implements Iterator<E> {
        private static final int c = 65537;
        private final List<E> internalList;
        private final int startIndex;
        private int index;
        private boolean isFinished;

        QuasiRandomIterator(List<E> list) {
            if (list.size() == 0) {
                throw new IllegalArgumentException();
            }
            this.internalList = list;
            this.isFinished = false;
            this.index = this.startIndex = (int)(Math.random() * (double)list.size());
        }

        @Override
        public boolean hasNext() {
            return !this.isFinished;
        }

        @Override
        public E next() {
            int oldIndex = this.index;
            this.advanceIndex();
            return this.internalList.get(oldIndex);
        }

        private void advanceIndex() {
            this.index = (this.index + 65537) % this.internalList.size();
            if (this.index == this.startIndex) {
                this.isFinished = true;
            }
        }
    }
}

