/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.collision.optimization;

import org.valkyrienskies.mod.common.physics.collision.optimization.IBitOctree;
import org.valkyrienskies.mod.common.physics.collision.optimization.IBitSet;
import org.valkyrienskies.mod.common.physics.collision.optimization.SmallBitSet;

public class SimpleBitOctree
implements IBitOctree {
    private final IBitSet bitbuffer = new SmallBitSet(4680);

    @Override
    public void set(int x, int y, int z, boolean bit) {
        int index = this.getBlockIndex(x, y, z);
        this.ensureCapacity(index);
        if (this.bitbuffer.get(index) != bit) {
            this.bitbuffer.set(index, bit);
            this.updateOctrees(x, y, z, bit);
        }
    }

    @Override
    public boolean get(int x, int y, int z) {
        return this.getAtIndex(this.getBlockIndex(x, y, z));
    }

    @Override
    public boolean getAtIndex(int index) {
        this.ensureCapacity(index);
        return this.bitbuffer.get(index);
    }

    @Override
    public int getOctreeLevelOneIndex(int levelTwoIndex, int offset) {
        return levelTwoIndex + offset + 1;
    }

    @Override
    public int getOctreeLevelTwoIndex(int levelThreeIndex, int offset) {
        return levelThreeIndex + 9 * offset + 1;
    }

    @Override
    public int getOctreeLevelThreeIndex(int offset) {
        return 4096 + 73 * offset;
    }

    private void ensureCapacity(int index) {
        if (index > 4680) {
            throw new IllegalArgumentException("Tried accessing an element out of bounds!");
        }
    }

    private void updateOctrees(int x, int y, int z, boolean bit) {
        int levelThreeIndex = this.getOctreeLevelThreeIndex(x, y, z);
        int levelTwoIndex = this.getOctreeLevelTwoIndex(x, y, z, levelThreeIndex);
        int levelOneIndex = this.getOctreeLevelOneIndex(x, y, z, levelTwoIndex);
        if (this.getAtIndex(levelOneIndex) != bit && this.updateOctreeLevelOne(levelOneIndex, x, y, z) && this.updateOctreeLevelTwo(levelTwoIndex)) {
            this.updateOctreeLevelThree(levelThreeIndex);
        }
    }

    private void updateOctreeLevelThree(int levelThreeIndex) {
        if (this.bitbuffer.get(levelThreeIndex + 1) || this.bitbuffer.get(levelThreeIndex + 10) || this.bitbuffer.get(levelThreeIndex + 19) || this.bitbuffer.get(levelThreeIndex + 28) || this.bitbuffer.get(levelThreeIndex + 37) || this.bitbuffer.get(levelThreeIndex + 46) || this.bitbuffer.get(levelThreeIndex + 55) || this.bitbuffer.get(levelThreeIndex + 64)) {
            this.bitbuffer.set(levelThreeIndex);
        } else {
            this.bitbuffer.clear(levelThreeIndex);
        }
    }

    private boolean updateOctreeLevelTwo(int levelTwoIndex) {
        if (this.bitbuffer.get(levelTwoIndex + 1) || this.bitbuffer.get(levelTwoIndex + 2) || this.bitbuffer.get(levelTwoIndex + 3) || this.bitbuffer.get(levelTwoIndex + 4) || this.bitbuffer.get(levelTwoIndex + 5) || this.bitbuffer.get(levelTwoIndex + 6) || this.bitbuffer.get(levelTwoIndex + 7) || this.bitbuffer.get(levelTwoIndex + 8)) {
            if (!this.bitbuffer.get(levelTwoIndex)) {
                this.bitbuffer.set(levelTwoIndex);
                return true;
            }
        } else if (this.bitbuffer.get(levelTwoIndex)) {
            this.bitbuffer.clear(levelTwoIndex);
            return true;
        }
        return false;
    }

    private boolean updateOctreeLevelOne(int levelOneIndex, int x, int y, int z) {
        if (this.get(x &= 0xE, y &= 0xE, z &= 0xE) || this.get(x, y, z + 1) || this.get(x, y + 1, z) || this.get(x, y + 1, z + 1) || this.get(x + 1, y, z) || this.get(x + 1, y, z + 1) || this.get(x + 1, y + 1, z) || this.get(x + 1, y + 1, z + 1)) {
            if (!this.bitbuffer.get(levelOneIndex)) {
                this.bitbuffer.set(levelOneIndex);
                return true;
            }
        } else if (this.bitbuffer.get(levelOneIndex)) {
            this.bitbuffer.clear(levelOneIndex);
            return true;
        }
        return false;
    }

    private int getOctreeLevelOneIndex(int x, int y, int z, int levelTwoIndex) {
        x = (x & 2) >> 1;
        z = (z & 2) << 1;
        return this.getOctreeLevelOneIndex(levelTwoIndex, x | (y &= 2) | z);
    }

    private int getOctreeLevelTwoIndex(int x, int y, int z, int levelThreeIndex) {
        x = (x & 4) >> 2;
        y = (y & 4) >> 1;
        return this.getOctreeLevelTwoIndex(levelThreeIndex, x | y | (z &= 4));
    }

    private int getOctreeLevelThreeIndex(int x, int y, int z) {
        x = (x & 8) >> 3;
        y = (y & 8) >> 2;
        z = (z & 8) >> 1;
        return this.getOctreeLevelThreeIndex(x | y | z);
    }

    private int getBlockIndex(int x, int y, int z) {
        return x | y << 4 | z << 8;
    }
}

