/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.collision.polygons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;

public class ClippedPolygon
extends Polygon {
    private final List<Vector> clippedVertices = new ArrayList<Vector>();
    private final List<Vector> clippedVerticesUnmodifiable;

    public ClippedPolygon(Polygon other, Vector planeNormal, Vector planePos) {
        super(other);
        for (Vector originalVertex : other.getVertices()) {
            if (!this.isVertexInFrontOfCullingPlane(originalVertex, planeNormal, planePos)) continue;
            this.clippedVertices.add(originalVertex);
        }
        this.clippedVerticesUnmodifiable = Collections.unmodifiableList(this.clippedVertices);
    }

    public List<Vector> getUnmodifiableClippedVertices() {
        return this.clippedVerticesUnmodifiable;
    }

    private boolean isVertexInFrontOfCullingPlane(Vector vertex, Vector planeNormal, Vector planePos) {
        Vector difference = vertex.getSubtraction(planePos);
        return difference.dot(planeNormal) < 0.0;
    }
}

