/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.collision.polygons;

import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.collision.EntityCollisionObject;
import org.valkyrienskies.mod.common.physics.collision.polygons.EntityPolygon;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;

public class EntityPolygonCollider {
    private final Vector[] collisionAxes;
    private final EntityCollisionObject[] collisions;
    private final EntityPolygon entity;
    private final Polygon block;
    private final Vector entityVelocity;
    private boolean seperated = false;
    private int minDistanceIndex;
    private double minDistance;
    private boolean originallySeperated;

    public EntityPolygonCollider(EntityPolygon movable, Polygon stationary, Vector[] axes, Vector entityVel) {
        this.collisionAxes = axes;
        this.entity = movable;
        this.block = stationary;
        this.entityVelocity = entityVel;
        this.collisions = new EntityCollisionObject[this.collisionAxes.length];
        this.processData();
    }

    public void processData() {
        int i;
        this.seperated = false;
        for (i = 0; i < this.collisions.length; ++i) {
            if (this.seperated) continue;
            this.collisions[i] = new EntityCollisionObject(this.entity, this.block, this.collisionAxes[i], this.entityVelocity);
            if (this.collisions[i].arePolygonsSeperated()) {
                this.seperated = true;
                break;
            }
            if (this.collisions[i].werePolygonsInitiallyColliding()) continue;
            this.originallySeperated = true;
        }
        if (!this.seperated) {
            this.minDistance = 420.0;
            for (i = 0; i < this.collisions.length; ++i) {
                if (this.originallySeperated) {
                    if (!(Math.abs((this.collisions[i].getCollisionPenetrationDistance() - this.collisions[i].getVelDot()) / this.collisions[i].getVelDot()) < this.minDistance) || this.collisions[i].werePolygonsInitiallyColliding()) continue;
                    this.minDistanceIndex = i;
                    this.minDistance = Math.abs((this.collisions[i].getCollisionPenetrationDistance() - this.collisions[i].getVelDot()) / this.collisions[i].getVelDot());
                    continue;
                }
                if (!(Math.abs(this.collisions[i].getCollisionPenetrationDistance()) < this.minDistance)) continue;
                this.minDistanceIndex = i;
                this.minDistance = Math.abs(this.collisions[i].getCollisionPenetrationDistance());
            }
        }
    }

    public EntityCollisionObject[] getCollisions() {
        return this.collisions;
    }

    public int getMinDistanceIndex() {
        return this.minDistanceIndex;
    }

    public boolean arePolygonsSeperated() {
        return this.seperated;
    }

    public Vector[] getCollisionAxes() {
        return this.collisionAxes;
    }
}

