/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.collision.polygons;

import org.valkyrienskies.mod.common.math.VSMath;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;

public class PhysCollisionObject {
    public final Vector collision_normal;
    public final Polygon movable;
    public final Polygon fixed;
    public double penetrationDistance;
    public boolean seperated;
    private double[] playerMinMax;
    private double[] blockMinMax;
    private double movMaxFixMin;
    private double movMinFixMax;
    private Vector firstContactPoint;

    public PhysCollisionObject(Polygon movable_, Polygon stationary, Vector axes) {
        this.collision_normal = axes;
        this.movable = movable_;
        this.fixed = stationary;
        this.generateCollision();
    }

    public void generateCollision() {
        this.playerMinMax = VSMath.getMinMaxOfArray(this.movable.getProjectionOnVector(this.collision_normal));
        this.blockMinMax = VSMath.getMinMaxOfArray(this.fixed.getProjectionOnVector(this.collision_normal));
        this.movMaxFixMin = this.playerMinMax[0] - this.blockMinMax[1];
        this.movMinFixMax = this.playerMinMax[1] - this.blockMinMax[0];
        if (this.movMaxFixMin > 0.0 || this.movMinFixMax < 0.0) {
            this.seperated = true;
            this.penetrationDistance = 0.0;
            return;
        }
        if (Math.abs(this.movMaxFixMin) > Math.abs(this.movMinFixMax)) {
            this.penetrationDistance = this.movMinFixMax;
            for (Vector v : this.movable.getVertices()) {
                if (v.dot(this.collision_normal) != this.playerMinMax[1]) continue;
                this.firstContactPoint = v;
            }
        } else {
            this.penetrationDistance = this.movMaxFixMin;
            for (Vector v : this.movable.getVertices()) {
                if (v.dot(this.collision_normal) != this.playerMinMax[0]) continue;
                this.firstContactPoint = v;
            }
        }
        this.seperated = false;
    }

    public Vector getSecondContactPoint() {
        if (Math.abs(this.movMaxFixMin) > Math.abs(this.movMinFixMax)) {
            for (Vector v : this.fixed.getVertices()) {
                if (v.dot(this.collision_normal) != this.blockMinMax[0]) continue;
                return v;
            }
        } else {
            for (Vector v : this.fixed.getVertices()) {
                if (v.dot(this.collision_normal) != this.blockMinMax[1]) continue;
                return v;
            }
        }
        return null;
    }

    public Vector getResponse() {
        return this.collision_normal.getProduct(this.penetrationDistance);
    }

    public void setResponse(Vector v) {
        v.X = this.collision_normal.X * this.penetrationDistance;
        v.Y = this.collision_normal.Y * this.penetrationDistance;
        v.Z = this.collision_normal.Z * this.penetrationDistance;
    }
}

