/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.collision.polygons;

import net.minecraft.util.math.AxisAlignedBB;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.math.Vector;
import valkyrienwarfare.api.TransformType;

public class Polygon {
    private final Vector[] vertices;
    private final Vector[] normals;

    public Polygon(AxisAlignedBB bb) {
        this.vertices = Polygon.getCornersForAABB(bb);
        this.normals = Vector.generateAxisAlignedNorms();
    }

    public Polygon(AxisAlignedBB bb, ShipTransform transformation, TransformType transformType) {
        this(bb);
        this.transform(transformation, transformType);
    }

    protected Polygon(Polygon other) {
        this.vertices = new Vector[other.vertices.length];
        this.normals = other.normals;
    }

    private static Vector[] getCornersForAABB(AxisAlignedBB bb) {
        return new Vector[]{new Vector(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c), new Vector(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c), new Vector(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f), new Vector(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f), new Vector(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c), new Vector(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c), new Vector(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f), new Vector(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f)};
    }

    public Vector[] getVertices() {
        return this.vertices;
    }

    public Vector[] getNormals() {
        return this.normals;
    }

    public double[] getProjectionOnVector(Vector axis) {
        double[] distances = new double[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            distances[i] = axis.dot(this.vertices[i]);
        }
        return distances;
    }

    public Vector getCenter() {
        Vector center = new Vector();
        for (Vector v : this.vertices) {
            center.add(v);
        }
        center.divide(this.vertices.length);
        return center;
    }

    public void transform(ShipTransform transformation, TransformType transformType) {
        for (Vector vertex : this.vertices) {
            transformation.transform(vertex, transformType);
        }
        for (Vector normal : this.normals) {
            transformation.rotate(normal, transformType);
        }
    }

    public AxisAlignedBB getEnclosedAABB() {
        Vector firstVertex = this.vertices[0];
        double mnX = firstVertex.X;
        double mnY = firstVertex.Y;
        double mnZ = firstVertex.Z;
        double mxX = firstVertex.X;
        double mxY = firstVertex.Y;
        double mxZ = firstVertex.Z;
        for (int i = 1; i < this.vertices.length; ++i) {
            Vector vertex = this.vertices[i];
            mnX = Math.min(mnX, vertex.X);
            mnY = Math.min(mnY, vertex.Y);
            mnZ = Math.min(mnZ, vertex.Z);
            mxX = Math.max(mxX, vertex.X);
            mxY = Math.max(mxY, vertex.Y);
            mxZ = Math.max(mxZ, vertex.Z);
        }
        return new AxisAlignedBB(mnX, mnY, mnZ, mxX, mxY, mxZ);
    }
}

