/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.collision.polygons;

import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.collision.polygons.ClippedPolygon;
import org.valkyrienskies.mod.common.physics.collision.polygons.PhysCollisionObject;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;

public class PolygonCollisionPointFinder {
    public static Vector[] getPointsOfCollisionForPolygons(PhysCollisionObject collisionInfo) {
        Polygon topPoly = null;
        Polygon bottomPoly = null;
        Vector collisionNormal = collisionInfo.collision_normal;
        Vector centerDifference = collisionInfo.movable.getCenter().getSubtraction(collisionInfo.fixed.getCenter());
        if (centerDifference.dot(collisionNormal) > 0.0) {
            topPoly = collisionInfo.fixed;
            bottomPoly = collisionInfo.movable;
        } else {
            topPoly = collisionInfo.movable;
            bottomPoly = collisionInfo.fixed;
        }
        double minDot = 9.9999999E7;
        int topPointIndex = -1;
        for (int i = 0; i < topPoly.getVertices().length; ++i) {
            double dotProduct = topPoly.getVertices()[i].dot(collisionNormal);
            if (!(dotProduct < minDot)) continue;
            minDot = dotProduct;
            topPointIndex = i;
        }
        double maxDot = -9.999999999E9;
        int bottomPointIndex = -1;
        for (int i = 0; i < bottomPoly.getVertices().length; ++i) {
            double dotProduct = bottomPoly.getVertices()[i].dot(collisionNormal);
            if (!(dotProduct > maxDot)) continue;
            maxDot = dotProduct;
            bottomPointIndex = i;
        }
        Vector currentTopVertex = topPoly.getVertices()[topPointIndex];
        Vector currentBottomVertex = bottomPoly.getVertices()[bottomPointIndex];
        boolean useFastCollision = true;
        if (useFastCollision) {
            return new Vector[]{currentTopVertex, currentBottomVertex, currentTopVertex, currentBottomVertex};
        }
        Vector topCullingNormal = null;
        double maxTopAbsDot = -1.0;
        for (Vector vector : topPoly.getNormals()) {
            double absDotProduct = Math.abs(vector.dot(collisionNormal));
            if (!(absDotProduct > maxTopAbsDot)) continue;
            topCullingNormal = vector;
            maxTopAbsDot = absDotProduct;
        }
        Vector bottomCullingNormal = null;
        double maxBottomAbsDot = -1.0;
        for (Vector bottomNormal : bottomPoly.getNormals()) {
            double absDotProduct = Math.abs(bottomNormal.dot(collisionNormal));
            if (!(absDotProduct > maxBottomAbsDot)) continue;
            bottomCullingNormal = bottomNormal;
            maxBottomAbsDot = absDotProduct;
        }
        if (topCullingNormal.dot(collisionNormal) > 0.0) {
            topCullingNormal = new Vector(topCullingNormal, -1.0);
        }
        if (bottomCullingNormal.dot(collisionNormal) < 0.0) {
            bottomCullingNormal = new Vector(bottomCullingNormal, -1.0);
        }
        ClippedPolygon clippedPolygon = new ClippedPolygon(topPoly, bottomCullingNormal, currentBottomVertex);
        ClippedPolygon clippedBottom = new ClippedPolygon(bottomPoly, topCullingNormal, currentTopVertex);
        return new Vector[]{currentTopVertex, currentBottomVertex, currentTopVertex, currentBottomVertex};
    }
}

