/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.management;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.physics.management.WorldPhysObjectManager;

public class DimensionPhysObjectManager {
    private final Map<World, WorldPhysObjectManager> managerPerWorld = new HashMap<World, WorldPhysObjectManager>();

    void onShipPreload(PhysicsWrapperEntity toPreload) {
        this.getManagerForWorld(toPreload.field_70170_p).preloadPhysicsWrapperEntityMappings(toPreload);
    }

    public void onShipLoad(PhysicsWrapperEntity justLoaded) {
        this.getManagerForWorld(justLoaded.field_70170_p).onLoad(justLoaded);
    }

    public void onShipUnload(PhysicsWrapperEntity justUnloaded) {
        this.getManagerForWorld(justUnloaded.field_70170_p).onUnload(justUnloaded);
    }

    public WorldPhysObjectManager getManagerForWorld(World world) {
        if (!this.managerPerWorld.containsKey(world)) {
            this.managerPerWorld.put(world, new WorldPhysObjectManager(world));
        }
        return this.managerPerWorld.get(world);
    }

    public void removeWorld(World world) {
        this.managerPerWorld.remove(world);
    }
}

