/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.management;

import com.google.common.collect.Sets;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.network.play.server.SPacketUnloadChunk;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;
import org.valkyrienskies.addon.control.nodenetwork.INodeController;
import org.valkyrienskies.fixes.IPhysicsChunk;
import org.valkyrienskies.mod.client.render.PhysObjectRenderManager;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.coordinates.ISubspace;
import org.valkyrienskies.mod.common.coordinates.ISubspaceProvider;
import org.valkyrienskies.mod.common.coordinates.ImplSubspace;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Quaternion;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.multithreaded.TickSyncCompletableFuture;
import org.valkyrienskies.mod.common.network.WrapperPositionMessage;
import org.valkyrienskies.mod.common.physics.BlockPhysicsDetails;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import org.valkyrienskies.mod.common.physics.collision.meshing.IVoxelFieldAABBMaker;
import org.valkyrienskies.mod.common.physics.collision.meshing.NaiveVoxelFieldAABBMaker;
import org.valkyrienskies.mod.common.physics.management.ShipTransformationManager;
import org.valkyrienskies.mod.common.physics.management.chunkcache.ClaimedChunkCacheController;
import org.valkyrienskies.mod.common.physics.management.chunkcache.SurroundingChunkCacheController;
import org.valkyrienskies.mod.common.physmanagement.chunk.VSChunkClaim;
import org.valkyrienskies.mod.common.physmanagement.relocation.DetectorManager;
import org.valkyrienskies.mod.common.physmanagement.relocation.MoveBlocks;
import org.valkyrienskies.mod.common.physmanagement.relocation.SpatialDetector;
import org.valkyrienskies.mod.common.tileentity.TileEntityPhysicsInfuser;
import org.valkyrienskies.mod.common.util.ValkyrienNBTUtils;
import valkyrienwarfare.api.IPhysicsEntity;
import valkyrienwarfare.api.TransformType;

public class PhysicsObject
implements ISubspaceProvider,
IPhysicsEntity {
    private final PhysicsWrapperEntity wrapperEntity;
    private final List<EntityPlayerMP> watchingPlayers;
    private final ISubspace shipSubspace;
    private final Set<INodeController> physicsControllers;
    private final Set<INodeController> physicsControllersImmutable;
    private final TIntArrayList blockPositionsGameTick;
    private PhysObjectRenderManager shipRenderer;
    private BlockPos referenceBlockPos;
    private Vector centerCoord;
    private ShipTransformationManager shipTransformationManager;
    private PhysicsCalculations physicsProcessor;
    private Set<BlockPos> blockPositions;
    private boolean isPhysicsEnabled = false;
    private String creator;
    private DetectorManager.DetectorIDs detectorID;
    private SurroundingChunkCacheController cachedSurroundingChunks;
    private VSChunkClaim ownedChunks;
    private ClaimedChunkCacheController claimedChunkCache;
    private AxisAlignedBB shipBoundingBox;
    private boolean needsCollisionCacheUpdate = true;
    private BlockPos physicsInfuserPos = null;
    private boolean shipAligningToGrid = false;
    private boolean isFullyLoaded = false;
    private IVoxelFieldAABBMaker voxelFieldAABBMaker;

    public PhysicsObject(PhysicsWrapperEntity host) {
        this.wrapperEntity = host;
        if (host.field_70170_p.field_72995_K) {
            this.shipRenderer = new PhysObjectRenderManager(this);
        }
        this.blockPositions = ConcurrentHashMap.newKeySet();
        this.shipBoundingBox = Entity.field_174836_a;
        this.watchingPlayers = new ArrayList<EntityPlayerMP>();
        this.shipSubspace = new ImplSubspace(this);
        this.physicsControllers = Sets.newConcurrentHashSet();
        this.physicsControllersImmutable = Collections.unmodifiableSet(this.physicsControllers);
        this.blockPositionsGameTick = new TIntArrayList();
        this.cachedSurroundingChunks = new SurroundingChunkCacheController(this);
        this.voxelFieldAABBMaker = null;
    }

    public void onSetBlockState(IBlockState oldState, IBlockState newState, BlockPos posAt) {
        boolean isNewAir;
        if (this.world().field_72995_K || !this.getOwnedChunks().containsBlock(posAt)) {
            return;
        }
        if (oldState != null && BlockPhysicsDetails.blocksToNotPhysicsInfuse.contains(oldState.func_177230_c())) {
            oldState = Blocks.field_150350_a.func_176223_P();
        }
        if (newState != null && BlockPhysicsDetails.blocksToNotPhysicsInfuse.contains(newState.func_177230_c())) {
            newState = Blocks.field_150350_a.func_176223_P();
        }
        boolean isOldAir = oldState == null || oldState.func_177230_c().equals(Blocks.field_150350_a);
        boolean bl = isNewAir = newState == null || newState.func_177230_c().equals(Blocks.field_150350_a);
        if (isNewAir) {
            boolean removed = this.getBlockPositions().remove(posAt);
            this.voxelFieldAABBMaker.removeVoxel(posAt.func_177958_n(), posAt.func_177956_o(), posAt.func_177952_p());
            if (removed) {
                this.blockPositionsGameTick.remove(this.getBlockPosToIntRelToShip(posAt));
            }
        }
        if (isOldAir && !isNewAir) {
            boolean isAdded = this.getBlockPositions().add(posAt);
            this.voxelFieldAABBMaker.addVoxel(posAt.func_177958_n(), posAt.func_177956_o(), posAt.func_177952_p());
            if (isAdded) {
                this.blockPositionsGameTick.add(this.getBlockPosToIntRelToShip(posAt));
            }
            int chunkRelativeX = (posAt.func_177958_n() >> 4) - this.getOwnedChunks().minX();
            int n = (posAt.func_177952_p() >> 4) - this.getOwnedChunks().minZ();
        }
        if (this.getBlockPositions().isEmpty()) {
            this.destroy();
        }
        if (this.getPhysicsProcessor() != null) {
            this.getPhysicsProcessor().onSetBlockState(oldState, newState, posAt);
        }
    }

    public void destroy() {
        this.getWrapperEntity().func_70106_y();
        ArrayList<EntityPlayerMP> watchersCopy = new ArrayList<EntityPlayerMP>(this.getWatchingPlayers());
        for (int x = this.getOwnedChunks().minX(); x <= this.getOwnedChunks().maxX(); ++x) {
            for (int z = this.getOwnedChunks().minZ(); z <= this.getOwnedChunks().maxZ(); ++z) {
                SPacketUnloadChunk unloadPacket = new SPacketUnloadChunk(x, z);
                for (EntityPlayerMP wachingPlayer : watchersCopy) {
                    wachingPlayer.field_71135_a.func_147359_a((Packet)unloadPacket);
                }
            }
        }
        this.getWatchingPlayers().clear();
        ValkyrienSkiesMod.VS_CHUNK_MANAGER.removeRegisteredChunksForShip(this.getWrapperEntity());
        ValkyrienSkiesMod.VS_CHUNK_MANAGER.removeShipPosition(this.getWrapperEntity());
        ValkyrienSkiesMod.VS_CHUNK_MANAGER.removeShipNameRegistry(this.getWrapperEntity());
        ValkyrienSkiesMod.VS_PHYSICS_MANAGER.onShipUnload(this.getWrapperEntity());
    }

    public void claimNewChunks(int radius) {
        this.setOwnedChunks(ValkyrienSkiesMod.VS_CHUNK_MANAGER.getManagerForWorld(this.getWrapperEntity().field_70170_p).getNextAvailableChunkSet(radius));
        ValkyrienSkiesMod.VS_CHUNK_MANAGER.registerChunksForShip(this.getWrapperEntity());
    }

    public TickSyncCompletableFuture<Void> assembleShipAsOrderedByPlayer(EntityPlayer player) {
        if (this.world().field_72995_K) {
            throw new IllegalStateException("This method cannot be invoked on client side!");
        }
        if (!(this.world() instanceof WorldServer)) {
            throw new IllegalStateException("The world " + this.world() + " wasn't an instance of WorldServer");
        }
        BlockPos centerInWorld = new BlockPos(this.getWrapperEntity().field_70165_t, this.getWrapperEntity().field_70163_u, this.getWrapperEntity().field_70161_v);
        WorldServer worldServerThread = (WorldServer)this.world();
        return TickSyncCompletableFuture.supplyAsync(() -> DetectorManager.getDetectorFor(this.getDetectorID(), centerInWorld, this.world(), VSConfig.maxShipSize + 1, true)).thenAcceptTickSync(detector -> {
            if (detector.foundSet.size() > VSConfig.maxShipSize || detector.cleanHouse) {
                System.err.println("Ship too big or bedrock detected!");
                if (player != null) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Ship construction canceled because its exceeding the ship size limit; or because it's attached to bedrock. Raise it with /physsettings maxshipsize [number]"));
                }
                this.getWrapperEntity().func_70106_y();
                return;
            }
            this.assembleShip(player, (SpatialDetector)detector, centerInWorld);
            this.markFullyLoaded();
        }, (IThreadListener)worldServerThread);
    }

    private void createPhysicsCalculations() {
        if (this.getPhysicsProcessor() == null) {
            this.setPhysicsProcessor(new PhysicsCalculations(this));
        }
    }

    private void assembleShip(EntityPlayer player, SpatialDetector detector, BlockPos centerInWorld) {
        this.setPhysicsEnabled(true);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        TIntIterator iter = detector.foundSet.iterator();
        int radiusNeeded = 1;
        while (iter.hasNext()) {
            int i = iter.next();
            SpatialDetector.setPosWithRespectTo(i, BlockPos.field_177992_a, pos);
            int xRad = Math.abs(pos.func_177958_n() >> 4);
            int zRad = Math.abs(pos.func_177952_p() >> 4);
            radiusNeeded = Math.max(Math.max(zRad, xRad), radiusNeeded + 1);
        }
        radiusNeeded = Math.min(radiusNeeded, 15);
        this.claimNewChunks(radiusNeeded);
        ValkyrienSkiesMod.VS_PHYSICS_MANAGER.onShipPreload(this.getWrapperEntity());
        this.claimedChunkCache = new ClaimedChunkCacheController(this, false);
        this.assignChunkPhysicObject();
        this.setReferenceBlockPos(this.getOwnedChunks().regionCenter());
        this.voxelFieldAABBMaker = new NaiveVoxelFieldAABBMaker(this.referenceBlockPos.func_177958_n(), this.referenceBlockPos.func_177952_p());
        this.setCenterCoord(new Vector((double)this.getReferenceBlockPos().func_177958_n() + 0.5, (double)this.getReferenceBlockPos().func_177956_o() + 0.5, (double)this.getReferenceBlockPos().func_177952_p() + 0.5));
        this.createPhysicsCalculations();
        iter = detector.foundSet.iterator();
        BlockPos centerDifference = this.getReferenceBlockPos().func_177973_b((Vec3i)centerInWorld);
        BlockPos.MutableBlockPos oldPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos();
        while (iter.hasNext()) {
            int i = iter.next();
            SpatialDetector.setPosWithRespectTo(i, centerInWorld, oldPos);
            SpatialDetector.setPosWithRespectTo(i, centerInWorld, newPos);
            newPos.func_181079_c(newPos.func_177958_n() + centerDifference.func_177958_n(), newPos.func_177956_o() + centerDifference.func_177956_o(), newPos.func_177952_p() + centerDifference.func_177952_p());
            MoveBlocks.copyBlockToPos(this.world(), (BlockPos)oldPos, (BlockPos)newPos, Optional.of(this));
            this.voxelFieldAABBMaker.addVoxel(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
        }
        this.physicsInfuserPos = this.physicsInfuserPos.func_177971_a((Vec3i)centerDifference);
        for (int i : detector.foundSet) {
            SpatialDetector.setPosWithRespectTo(i, centerInWorld, pos);
            TileEntity tile = this.world().func_175625_s((BlockPos)pos);
            if (tile == null || tile.func_145837_r()) continue;
            try {
                tile.func_145843_s();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.world().func_175713_t((BlockPos)pos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i : detector.foundSet) {
            SpatialDetector.setPosWithRespectTo(i, centerInWorld, pos);
            this.world().func_180501_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        for (int x = this.getOwnedChunks().minX(); x <= this.getOwnedChunks().maxX(); ++x) {
            for (int z = this.getOwnedChunks().minZ(); z <= this.getOwnedChunks().maxZ(); ++z) {
                this.claimedChunkCache.getChunkAt(x, z).func_150809_p();
            }
        }
        this.getWrapperEntity().field_70165_t += 0.5;
        this.getWrapperEntity().field_70163_u += 0.5;
        this.getWrapperEntity().field_70161_v += 0.5;
        this.detectgetBlockPositions();
        this.setShipTransformationManager(new ShipTransformationManager(this));
        this.getPhysicsProcessor().updateParentCenterOfMass();
    }

    public void preloadNewPlayers() {
        Set<EntityPlayerMP> newWatchers = this.getPlayersThatJustWatched();
        Chunk[][] chunkArray = this.claimedChunkCache.getCacheArray();
        int n = chunkArray.length;
        for (int i = 0; i < n; ++i) {
            Chunk[] chunkArray2;
            for (Chunk chunk : chunkArray2 = chunkArray[i]) {
                SPacketChunkData data = new SPacketChunkData(chunk, 65535);
                for (EntityPlayerMP player : newWatchers) {
                    player.field_71135_a.func_147359_a((Packet)data);
                    ((WorldServer)this.world()).func_73039_n().func_85172_a(player, chunk);
                }
            }
        }
    }

    public void onPlayerUntracking(EntityPlayer untracking) {
        this.getWatchingPlayers().remove(untracking);
        for (int x = this.getOwnedChunks().minX(); x <= this.getOwnedChunks().maxX(); ++x) {
            for (int z = this.getOwnedChunks().minZ(); z <= this.getOwnedChunks().maxZ(); ++z) {
                SPacketUnloadChunk unloadPacket = new SPacketUnloadChunk(x, z);
                ((EntityPlayerMP)untracking).field_71135_a.func_147359_a((Packet)unloadPacket);
            }
        }
    }

    public void onThisUnload() {
        if (!this.world().field_72995_K) {
            this.unloadShipChunksFromWorld();
        } else {
            this.getShipRenderer().killRenderers();
        }
    }

    public void unloadShipChunksFromWorld() {
        ChunkProviderServer provider = (ChunkProviderServer)this.world().func_72863_F();
        for (int x = this.getOwnedChunks().minX(); x <= this.getOwnedChunks().maxX(); ++x) {
            for (int z = this.getOwnedChunks().minZ(); z <= this.getOwnedChunks().maxZ(); ++z) {
                provider.func_189549_a(this.claimedChunkCache.getChunkAt(x, z));
            }
        }
    }

    private Set<EntityPlayerMP> getPlayersThatJustWatched() {
        HashSet<EntityPlayerMP> newPlayers = new HashSet<EntityPlayerMP>();
        for (Object o : ((WorldServer)this.world()).func_73039_n().getTrackingPlayers((Entity)this.getWrapperEntity())) {
            EntityPlayerMP player = (EntityPlayerMP)o;
            if (this.getWatchingPlayers().contains(player)) continue;
            newPlayers.add(player);
            this.getWatchingPlayers().add(player);
        }
        return newPlayers;
    }

    public void onTick() {
        if (!this.world().field_72995_K) {
            boolean shouldDeconstructShip;
            TileEntity te = this.world().func_175625_s(this.physicsInfuserPos);
            if (te instanceof TileEntityPhysicsInfuser) {
                TileEntityPhysicsInfuser physicsCore = (TileEntityPhysicsInfuser)te;
                shouldDeconstructShip = !physicsCore.canMaintainShip() || physicsCore.isTryingToDisassembleShip();
                this.shipAligningToGrid = !physicsCore.canMaintainShip() || physicsCore.isTryingToAlignShip();
                this.setPhysicsEnabled(!physicsCore.canMaintainShip() || physicsCore.isPhysicsEnabled());
            } else {
                this.shipAligningToGrid = true;
                shouldDeconstructShip = true;
                this.setPhysicsEnabled(true);
            }
            if (shouldDeconstructShip) {
                this.tryToDeconstructShip();
            }
        }
        this.setNeedsCollisionCacheUpdate(false);
    }

    public void onPostTick() {
        if (!this.getWrapperEntity().field_70128_L && !this.getWrapperEntity().field_70170_p.field_72995_K) {
            ValkyrienSkiesMod.VS_CHUNK_MANAGER.updateShipPosition(this.getWrapperEntity());
        }
    }

    public void onPostTickClient() {
        WrapperPositionMessage toUse = this.getShipTransformationManager().serverBuffer.pollForClientTransform();
        if (toUse != null) {
            toUse.applySmoothLerp(this, 0.6);
        }
        this.getShipTransformationManager().updateAllTransforms(false, false, true);
    }

    public void updateChunkCache() {
        this.cachedSurroundingChunks.updateChunkCache();
    }

    public void loadClaimedChunks() {
        ValkyrienSkiesMod.VS_PHYSICS_MANAGER.onShipPreload(this.getWrapperEntity());
        this.claimedChunkCache = new ClaimedChunkCacheController(this, true);
        this.assignChunkPhysicObject();
        this.setReferenceBlockPos(this.getOwnedChunks().regionCenter());
        this.voxelFieldAABBMaker = new NaiveVoxelFieldAABBMaker(this.referenceBlockPos.func_177958_n(), this.referenceBlockPos.func_177952_p());
        this.setShipTransformationManager(new ShipTransformationManager(this));
        if (!this.world().field_72995_K) {
            this.createPhysicsCalculations();
            this.detectgetBlockPositions();
        }
    }

    public void detectgetBlockPositions() {
        Chunk[][] claimedChunks = this.claimedChunkCache.getCacheArray();
        int airStateIndex = Block.func_176210_f((IBlockState)Blocks.field_150350_a.func_176223_P());
        for (int chunkX = claimedChunks.length - 1; chunkX > -1; --chunkX) {
            for (int chunkZ = claimedChunks[0].length - 1; chunkZ > -1; --chunkZ) {
                Chunk chunk = claimedChunks[chunkX][chunkZ];
                if (chunk == null) continue;
                for (int index = 0; index < 16; ++index) {
                    ExtendedBlockStorage storage = chunk.func_76587_i()[index];
                    if (storage == null) continue;
                    for (int y = 0; y < 16; ++y) {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                if (storage.field_177488_d.field_186021_b.func_188142_a(y << 8 | z << 4 | x) == airStateIndex) continue;
                                BlockPos pos = new BlockPos(chunk.field_76635_g * 16 + x, index * 16 + y, chunk.field_76647_h * 16 + z);
                                this.getBlockPositions().add(pos);
                                this.blockPositionsGameTick.add(this.getBlockPosToIntRelToShip(pos));
                                this.voxelFieldAABBMaker.addVoxel(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                                if (!BlockPhysicsDetails.isBlockProvidingForce(this.world().func_180495_p(pos), pos, this.world())) continue;
                                this.getPhysicsProcessor().addPotentialActiveForcePos(pos);
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean ownsChunk(int chunkX, int chunkZ) {
        return this.getOwnedChunks().containsChunk(chunkX, chunkZ);
    }

    public void writeToNBTTag(NBTTagCompound compound) {
        this.getOwnedChunks().writeToNBT(compound);
        ValkyrienNBTUtils.writeVectorToNBT("c", this.getCenterCoord(), compound);
        this.getShipTransformationManager().getCurrentTickTransform().writeToNBT(compound, "current_tick_transform");
        compound.func_74757_a("doPhysics", this.isPhysicsEnabled);
        this.getPhysicsProcessor().writeToNBTTag(compound);
        compound.func_74778_a("owner", this.getCreator());
        ValkyrienNBTUtils.writeAABBToNBT("collision_aabb", this.getShipBoundingBox(), compound);
        ValkyrienNBTUtils.writeBlockPosToNBT("physics_infuser_pos", this.physicsInfuserPos, compound);
    }

    public void readFromNBTTag(NBTTagCompound compound) {
        this.setCenterCoord(ValkyrienNBTUtils.readVectorFromNBT("c", compound));
        this.createPhysicsCalculations();
        assert (this.getPhysicsProcessor() != null) : "Insert error message here";
        this.setOwnedChunks(new VSChunkClaim(compound));
        ShipTransform savedTransform = ShipTransform.readFromNBT(compound, "current_tick_transform");
        if (savedTransform != null) {
            Vector centerOfMassInGlobal = new Vector(this.getCenterCoord());
            savedTransform.transform(centerOfMassInGlobal, TransformType.SUBSPACE_TO_GLOBAL);
            this.getWrapperEntity().field_70165_t = centerOfMassInGlobal.X;
            this.getWrapperEntity().field_70163_u = centerOfMassInGlobal.Y;
            this.getWrapperEntity().field_70161_v = centerOfMassInGlobal.Z;
            Quaternion rotationQuaternion = savedTransform.createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
            double[] angles = rotationQuaternion.toRadians();
            this.getWrapperEntity().setPhysicsEntityRotation(Math.toDegrees(angles[0]), Math.toDegrees(angles[1]), Math.toDegrees(angles[2]));
        } else {
            this.getWrapperEntity().setPhysicsEntityRotation(compound.func_74769_h("pitch"), compound.func_74769_h("yaw"), compound.func_74769_h("roll"));
        }
        this.loadClaimedChunks();
        this.getPhysicsProcessor().readFromNBTTag(compound);
        this.setCreator(compound.func_74779_i("owner"));
        this.setShipBoundingBox(ValkyrienNBTUtils.readAABBFromNBT("collision_aabb", compound));
        this.setPhysicsEnabled(compound.func_74767_n("doPhysics"));
        this.physicsInfuserPos = ValkyrienNBTUtils.readBlockPosFromNBT("physics_infuser_pos", compound);
        this.markFullyLoaded();
    }

    public void readSpawnData(ByteBuf additionalData) {
        PacketBuffer modifiedBuffer = new PacketBuffer(additionalData);
        this.setOwnedChunks(new VSChunkClaim(modifiedBuffer.readInt(), modifiedBuffer.readInt(), modifiedBuffer.readInt()));
        double posX = modifiedBuffer.readDouble();
        double posY = modifiedBuffer.readDouble();
        double posZ = modifiedBuffer.readDouble();
        double pitch = modifiedBuffer.readDouble();
        double yaw = modifiedBuffer.readDouble();
        double roll = modifiedBuffer.readDouble();
        this.getWrapperEntity().setPhysicsEntityPositionAndRotation(posX, posY, posZ, pitch, yaw, roll);
        this.getWrapperEntity().physicsUpdateLastTickPositions();
        this.setCenterCoord(new Vector((ByteBuf)modifiedBuffer));
        this.loadClaimedChunks();
        this.getShipRenderer().updateOffsetPos(this.getReferenceBlockPos());
        this.getShipTransformationManager().serverBuffer.pushMessage(new WrapperPositionMessage(this));
        if (modifiedBuffer.readBoolean()) {
            this.setPhysicsInfuserPos(modifiedBuffer.func_179259_c());
        }
        this.markFullyLoaded();
    }

    public void writeSpawnData(ByteBuf buffer) {
        PacketBuffer modifiedBuffer = new PacketBuffer(buffer);
        modifiedBuffer.writeInt(this.getOwnedChunks().getCenterX());
        modifiedBuffer.writeInt(this.getOwnedChunks().getCenterZ());
        modifiedBuffer.writeInt(this.getOwnedChunks().getRadius());
        modifiedBuffer.writeDouble(this.getWrapperEntity().field_70165_t);
        modifiedBuffer.writeDouble(this.getWrapperEntity().field_70163_u);
        modifiedBuffer.writeDouble(this.getWrapperEntity().field_70161_v);
        modifiedBuffer.writeDouble(this.getWrapperEntity().getPitch());
        modifiedBuffer.writeDouble(this.getWrapperEntity().getYaw());
        modifiedBuffer.writeDouble(this.getWrapperEntity().getRoll());
        this.getCenterCoord().writeToByteBuf((ByteBuf)modifiedBuffer);
        BlockPos physicsInfuserPosLocal = this.getPhysicsInfuserPos();
        modifiedBuffer.writeBoolean(physicsInfuserPosLocal != null);
        if (physicsInfuserPosLocal != null) {
            modifiedBuffer.func_179255_a(physicsInfuserPosLocal);
        }
    }

    public World world() {
        return this.getWrapperEntity().func_130014_f_();
    }

    public void resetConsecutiveProperTicks() {
        this.setNeedsCollisionCacheUpdate(true);
    }

    private void assignChunkPhysicObject() {
        for (int x = this.ownedChunks.minX(); x <= this.ownedChunks.maxX(); ++x) {
            for (int z = this.ownedChunks.minZ(); z <= this.ownedChunks.maxZ(); ++z) {
                ((IPhysicsChunk)this.getChunkAt(x, z)).setParentPhysicsObject(Optional.of(this));
            }
        }
    }

    public ChunkCache getCachedSurroundingChunks() {
        return this.cachedSurroundingChunks.getCachedChunks();
    }

    @Override
    public ISubspace getSubspace() {
        return this.shipSubspace;
    }

    public void onSetTileEntity(BlockPos pos, TileEntity tileentity) {
        if (tileentity instanceof INodeController) {
            this.physicsControllers.add((INodeController)tileentity);
        }
    }

    public void onRemoveTileEntity(BlockPos pos) {
        this.physicsControllers.removeIf(next -> next.getNodePos().equals((Object)pos));
    }

    public Set<INodeController> getPhysicsControllersInShip() {
        return this.physicsControllersImmutable;
    }

    private int getBlockPosToIntRelToShip(BlockPos pos) {
        return SpatialDetector.getHashWithRespectTo(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.referenceBlockPos);
    }

    void setBlockPosFromIntRelToShop(int pos, BlockPos.MutableBlockPos toSet) {
        SpatialDetector.setPosWithRespectTo(pos, this.referenceBlockPos, toSet);
    }

    public boolean canShipBeDeconstructed() {
        Quaternion shipQuat;
        ShipTransform zeroTransform = ShipTransform.createRotationTransform(0.0, 0.0, 0.0);
        Quaternion zeroQuat = zeroTransform.createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        double dotProduct = Quaternion.dotProduct(zeroQuat, shipQuat = this.getShipTransformationManager().getCurrentTickTransform().createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL));
        double anglesBetweenQuaternions = Math.toDegrees(Math.acos(dotProduct));
        return anglesBetweenQuaternions < 0.5;
    }

    public void tryToDeconstructShip() {
        if (!this.canShipBeDeconstructed()) {
            return;
        }
        BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos();
        BlockPos centerDifference = new BlockPos((double)Math.round(this.centerCoord.X - this.getWrapperEntity().field_70165_t), (double)Math.round(this.centerCoord.Y - this.getWrapperEntity().field_70163_u), (double)Math.round(this.centerCoord.Z - this.getWrapperEntity().field_70161_v));
        for (BlockPos oldPos : this.blockPositions) {
            newPos.func_181079_c(oldPos.func_177958_n() - centerDifference.func_177958_n(), oldPos.func_177956_o() - centerDifference.func_177956_o(), oldPos.func_177952_p() - centerDifference.func_177952_p());
            MoveBlocks.copyBlockToPos(this.world(), oldPos, (BlockPos)newPos, Optional.empty());
        }
        for (BlockPos oldPos : this.blockPositions) {
            this.world().func_175713_t(oldPos);
        }
        for (int x = this.getOwnedChunks().minX(); x <= this.getOwnedChunks().maxX(); ++x) {
            for (int z = this.getOwnedChunks().minZ(); z <= this.getOwnedChunks().maxZ(); ++z) {
                Chunk chunk = new Chunk(this.world(), x, z);
                chunk.func_177446_d(true);
                chunk.func_177421_e(true);
                this.claimedChunkCache.injectChunkIntoWorld(chunk, x, z, true);
                this.claimedChunkCache.setChunkAt(x, z, chunk);
            }
        }
        this.destroy();
    }

    public boolean getShipAligningToGrid() {
        return this.shipAligningToGrid;
    }

    @Override
    public Vec3d rotateVector(Vec3d vector, TransformType transformType) {
        return this.getShipTransformationManager().getCurrentTickTransform().rotate(vector, transformType);
    }

    @Override
    public Vec3d transformVector(Vec3d vector, TransformType transformType) {
        return this.getShipTransformationManager().getCurrentTickTransform().transform(vector, transformType);
    }

    public Chunk getChunkAt(int chunkX, int chunkZ) {
        return this.claimedChunkCache.getChunkAt(chunkX, chunkZ);
    }

    private void markFullyLoaded() {
        this.getShipTransformationManager().updateAllTransforms(!this.world().field_72995_K, true, true);
        this.isFullyLoaded = true;
    }

    public PhysicsWrapperEntity getWrapperEntity() {
        return this.wrapperEntity;
    }

    public List<EntityPlayerMP> getWatchingPlayers() {
        return this.watchingPlayers;
    }

    TIntArrayList getBlockPositionsGameTick() {
        return this.blockPositionsGameTick;
    }

    public PhysObjectRenderManager getShipRenderer() {
        return this.shipRenderer;
    }

    public BlockPos getReferenceBlockPos() {
        return this.referenceBlockPos;
    }

    private void setReferenceBlockPos(BlockPos referenceBlockPos) {
        this.referenceBlockPos = referenceBlockPos;
    }

    public Vector getCenterCoord() {
        return this.centerCoord;
    }

    public void setCenterCoord(Vector centerCoord) {
        this.centerCoord = centerCoord;
    }

    public ShipTransformationManager getShipTransformationManager() {
        return this.shipTransformationManager;
    }

    private void setShipTransformationManager(ShipTransformationManager shipTransformationManager) {
        this.shipTransformationManager = shipTransformationManager;
    }

    public PhysicsCalculations getPhysicsProcessor() {
        return this.physicsProcessor;
    }

    public void setPhysicsProcessor(PhysicsCalculations physicsProcessor) {
        this.physicsProcessor = physicsProcessor;
    }

    public Set<BlockPos> getBlockPositions() {
        return this.blockPositions;
    }

    public boolean isPhysicsEnabled() {
        return this.isPhysicsEnabled;
    }

    public void setPhysicsEnabled(boolean isPhysicsEnabled) {
        this.isPhysicsEnabled = isPhysicsEnabled;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public DetectorManager.DetectorIDs getDetectorID() {
        return this.detectorID;
    }

    public void setDetectorID(DetectorManager.DetectorIDs detectorID) {
        this.detectorID = detectorID;
    }

    public VSChunkClaim getOwnedChunks() {
        return this.ownedChunks;
    }

    public void setOwnedChunks(VSChunkClaim ownedChunks) {
        this.ownedChunks = ownedChunks;
    }

    public ClaimedChunkCacheController getClaimedChunkCache() {
        return this.claimedChunkCache;
    }

    public AxisAlignedBB getShipBoundingBox() {
        return this.shipBoundingBox;
    }

    public void setShipBoundingBox(AxisAlignedBB shipBoundingBox) {
        this.shipBoundingBox = shipBoundingBox;
    }

    public boolean isNeedsCollisionCacheUpdate() {
        return this.needsCollisionCacheUpdate;
    }

    private void setNeedsCollisionCacheUpdate(boolean needsCollisionCacheUpdate) {
        this.needsCollisionCacheUpdate = needsCollisionCacheUpdate;
    }

    public BlockPos getPhysicsInfuserPos() {
        return this.physicsInfuserPos;
    }

    public void setPhysicsInfuserPos(BlockPos physicsInfuserPos) {
        this.physicsInfuserPos = physicsInfuserPos;
    }

    public boolean isFullyLoaded() {
        return this.isFullyLoaded;
    }

    public IVoxelFieldAABBMaker getVoxelFieldAABBMaker() {
        return this.voxelFieldAABBMaker;
    }
}

