/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.management;

import java.util.List;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.multithreaded.PhysicsShipTransform;
import org.valkyrienskies.mod.common.physics.management.WorldPhysObjectManager;
import org.valkyrienskies.mod.common.physmanagement.interaction.EntityDraggable;

public class PhysicsTickHandler {
    public static void onWorldTickStart(World world) {
        WorldPhysObjectManager manager = ValkyrienSkiesMod.VS_PHYSICS_MANAGER.getManagerForWorld(world);
        List<PhysicsWrapperEntity> physicsEntities = manager.getTickablePhysicsEntities();
        for (PhysicsWrapperEntity wrapper : physicsEntities) {
            if (wrapper.getPhysicsObject().getShipTransformationManager().getCurrentPhysicsTransform() instanceof PhysicsShipTransform) {
                PhysicsShipTransform physTransform = (PhysicsShipTransform)wrapper.getPhysicsObject().getShipTransformationManager().getCurrentPhysicsTransform();
                wrapper.physicsUpdateLastTickPositions();
                wrapper.setPhysicsEntityPositionAndRotation(physTransform.getPosX(), physTransform.getPosY(), physTransform.getPosZ(), physTransform.getPitch(), physTransform.getYaw(), physTransform.getRoll());
                wrapper.getPhysicsObject().getShipTransformationManager().updateAllTransforms(false, true, true);
            }
            wrapper.getPhysicsObject().updateChunkCache();
        }
    }

    public static void onWorldTickEnd(World world) {
        WorldPhysObjectManager manager = ValkyrienSkiesMod.VS_PHYSICS_MANAGER.getManagerForWorld(world);
        List<PhysicsWrapperEntity> physicsEntities = manager.getTickablePhysicsEntities();
        EntityDraggable.tickAddedVelocityForWorld(world);
        for (PhysicsWrapperEntity wrapperEnt : physicsEntities) {
            wrapperEnt.getPhysicsObject().onPostTick();
        }
    }
}

