/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.management;

import java.util.LinkedList;
import org.valkyrienskies.mod.common.network.WrapperPositionMessage;

public class ShipTransformationBuffer {
    public static final int PACKET_BUFFER_SIZE = 50;
    public static final int TRANSFORMS_SMOOTHED = 5;
    public static final double TRANFORMATION_DELAY = 0.5;
    private final LinkedList<WrapperPositionMessage> transformations = new LinkedList();
    private final BezierWeightGenerator weightGenerator = new BezierWeightGenerator(5);

    public void pushMessage(WrapperPositionMessage toPush) {
        this.transformations.push(new WrapperPositionMessage(toPush));
        if (this.transformations.size() > 50) {
            this.transformations.removeLast();
        }
    }

    public WrapperPositionMessage pollForClientTransform() {
        if (this.isSmoothTransformReady()) {
            return this.generateSmoothTransform();
        }
        return null;
    }

    private boolean isSmoothTransformReady() {
        return true;
    }

    private WrapperPositionMessage generateSmoothTransform() {
        return this.transformations.pollFirst();
    }

    private static class BezierWeightGenerator {
        private final int order;

        BezierWeightGenerator(int order) {
            this.order = order;
        }

        public double getTermWeight(double deltaTime, int term) {
            return 2.0 * Math.pow(deltaTime, term) * Math.pow(1.0 - deltaTime, this.order - term) * (double)this.binomial(4, term);
        }

        private int binomial(int n, int k) {
            if (k > n - k) {
                k = n - k;
            }
            int b = 1;
            int i = 1;
            int m = n;
            while (i <= k) {
                b = b * m / i;
                ++i;
                --m;
            }
            return b;
        }
    }
}

