/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.management;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Quaternion;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.multithreaded.PhysicsShipTransform;
import org.valkyrienskies.mod.common.network.WrapperPositionMessage;
import org.valkyrienskies.mod.common.physics.collision.meshing.IVoxelFieldAABBMaker;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physics.management.ShipTransformationBuffer;
import valkyrienwarfare.api.TransformType;

public class ShipTransformationManager {
    public static final ShipTransform ZERO_TRANSFORM = new ShipTransform();
    public final ShipTransformationBuffer serverBuffer;
    private final PhysicsObject parent;
    public Vector[] normals;
    private ShipTransform currentTickTransform;
    private ShipTransform renderTransform;
    private ShipTransform prevTickTransform;
    private ShipTransform currentPhysicsTransform;
    private ShipTransform prevPhysicsTransform;

    public ShipTransformationManager(PhysicsObject parent) {
        this.parent = parent;
        this.currentTickTransform = null;
        this.renderTransform = null;
        this.prevTickTransform = null;
        this.currentPhysicsTransform = null;
        this.prevPhysicsTransform = null;
        this.normals = null;
        this.serverBuffer = new ShipTransformationBuffer();
    }

    public void updateCurrentTickTransform() {
        PhysicsWrapperEntity wrapperEntity = this.parent.getWrapperEntity();
        ShipTransform newTickTransform = new ShipTransform(wrapperEntity.field_70165_t, wrapperEntity.field_70163_u, wrapperEntity.field_70161_v, wrapperEntity.getPitch(), wrapperEntity.getYaw(), wrapperEntity.getRoll(), this.parent.getCenterCoord());
        this.setCurrentTickTransform(newTickTransform);
    }

    @Deprecated
    public void updateAllTransforms(boolean updatePhysicsTransform, boolean updateParentAABB, boolean updatePassengers) {
        this.prevTickTransform = this.currentTickTransform;
        if (this.parent.world().field_72995_K) {
            updateParentAABB = false;
        }
        this.forceShipIntoWorldBorder();
        this.updateCurrentTickTransform();
        if (this.prevTickTransform == null) {
            this.prevTickTransform = this.currentTickTransform;
        }
        if (updatePhysicsTransform) {
            this.parent.getPhysicsProcessor().generatePhysicsTransform();
            this.prevPhysicsTransform = this.currentPhysicsTransform;
        }
        if (updateParentAABB) {
            this.updateParentAABB();
        }
        this.updateParentNormals();
        if (updatePassengers) {
            this.updatePassengerPositions();
        }
    }

    private void forceShipIntoWorldBorder() {
        WorldBorder border = this.parent.world().func_175723_af();
        AxisAlignedBB shipBB = this.parent.getShipBoundingBox();
        if (shipBB.field_72336_d > border.func_177728_d()) {
            this.parent.getWrapperEntity().field_70165_t += border.func_177728_d() - shipBB.field_72336_d;
        }
        if (shipBB.field_72340_a < border.func_177726_b()) {
            this.parent.getWrapperEntity().field_70165_t += border.func_177726_b() - shipBB.field_72340_a;
        }
        if (shipBB.field_72334_f > border.func_177733_e()) {
            this.parent.getWrapperEntity().field_70161_v += border.func_177733_e() - shipBB.field_72334_f;
        }
        if (shipBB.field_72339_c < border.func_177736_c()) {
            this.parent.getWrapperEntity().field_70161_v += border.func_177736_c() - shipBB.field_72339_c;
        }
    }

    public void updatePassengerPositions() {
        for (Entity entity : this.parent.getWrapperEntity().field_184244_h) {
            this.parent.getWrapperEntity().func_184232_k(entity);
        }
    }

    public void sendPositionToPlayers(int positionTickID) {
        WrapperPositionMessage posMessage = null;
        posMessage = this.getCurrentPhysicsTransform() != ZERO_TRANSFORM ? new WrapperPositionMessage((PhysicsShipTransform)this.getCurrentPhysicsTransform(), this.parent.getWrapperEntity().func_145782_y(), positionTickID) : new WrapperPositionMessage(this.parent.getWrapperEntity(), positionTickID);
        for (int i = 0; i < this.parent.getWatchingPlayers().size(); ++i) {
            EntityPlayerMP player = this.parent.getWatchingPlayers().get(i);
            if (player == null) continue;
            ValkyrienSkiesMod.physWrapperNetwork.sendTo((IMessage)posMessage, player);
        }
    }

    private void updateParentNormals() {
        int i;
        Vector[] newNormals = new Vector[15];
        Vector[] alignedNorms = Vector.generateAxisAlignedNorms();
        Vector[] rotatedNorms = this.generateRotationNormals();
        for (int i2 = 0; i2 < 6; ++i2) {
            Vector currentNorm = i2 < 3 ? alignedNorms[i2] : rotatedNorms[i2 - 3];
            newNormals[i2] = currentNorm;
        }
        int cont = 6;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Vector norm;
                newNormals[cont] = norm = newNormals[i].crossAndUnit(newNormals[j + 3]);
                ++cont;
            }
        }
        for (i = 0; i < newNormals.length; ++i) {
            if (!newNormals[i].isZero()) continue;
            newNormals[i] = new Vector(0.0, 1.0, 0.0);
        }
        newNormals[0] = new Vector(1.0, 0.0, 0.0);
        newNormals[1] = new Vector(0.0, 1.0, 0.0);
        newNormals[2] = new Vector(0.0, 0.0, 1.0);
        this.normals = newNormals;
    }

    private Vector[] generateRotationNormals() {
        Vector[] norms = Vector.generateAxisAlignedNorms();
        for (int i = 0; i < 3; ++i) {
            this.getCurrentTickTransform().rotate(norms[i], TransformType.SUBSPACE_TO_GLOBAL);
        }
        return norms;
    }

    private void updateParentAABB() {
        IVoxelFieldAABBMaker aabbMaker = this.parent.getVoxelFieldAABBMaker();
        AxisAlignedBB subspaceBB = aabbMaker.makeVoxelFieldAABB();
        if (subspaceBB == null) {
            return;
        }
        subspaceBB = subspaceBB.func_72321_a(1.0, 1.0, 1.0);
        Polygon largerPoly = new Polygon(subspaceBB, this.getCurrentTickTransform(), TransformType.SUBSPACE_TO_GLOBAL);
        AxisAlignedBB worldBB = largerPoly.getEnclosedAABB();
        this.parent.setShipBoundingBox(worldBB);
    }

    public void fromGlobalToLocal(Vector inGlobal) {
        this.getCurrentTickTransform().transform(inGlobal, TransformType.GLOBAL_TO_SUBSPACE);
    }

    public void fromLocalToGlobal(Vector inLocal) {
        this.getCurrentTickTransform().transform(inLocal, TransformType.SUBSPACE_TO_GLOBAL);
    }

    public ShipTransform getCurrentTickTransform() {
        return this.currentTickTransform;
    }

    @Deprecated
    private void setCurrentTickTransform(ShipTransform currentTransform) {
        this.currentTickTransform = currentTransform;
    }

    public ShipTransform getRenderTransform() {
        if (!this.parent.world().field_72995_K || this.renderTransform == null) {
            return this.currentTickTransform;
        }
        return this.renderTransform;
    }

    public ShipTransform getPrevTickTransform() {
        return this.prevTickTransform;
    }

    public ShipTransform getCurrentPhysicsTransform() {
        return this.currentPhysicsTransform;
    }

    public void setCurrentPhysicsTransform(ShipTransform currentPhysicsTransform) {
        this.currentPhysicsTransform = currentPhysicsTransform;
    }

    public ShipTransform getPrevPhysicsTransform() {
        return this.prevPhysicsTransform;
    }

    public void updatePreviousPhysicsTransform() {
        this.prevPhysicsTransform = this.currentPhysicsTransform;
    }

    public void updateRenderTransform(double partialTick) {
        if (partialTick == 0.0) {
            this.renderTransform = this.prevTickTransform;
            return;
        }
        if (partialTick == 1.0) {
            this.renderTransform = this.currentTickTransform;
            return;
        }
        ShipTransform prev = this.prevTickTransform;
        ShipTransform cur = this.currentTickTransform;
        Vector shipCenter = this.parent.getCenterCoord();
        Vector prevPos = new Vector(shipCenter);
        Vector curPos = new Vector(shipCenter);
        prev.transform(prevPos, TransformType.SUBSPACE_TO_GLOBAL);
        cur.transform(curPos, TransformType.SUBSPACE_TO_GLOBAL);
        Vector deltaPos = prevPos.getSubtraction(curPos);
        deltaPos.multiply(partialTick);
        Vector partialPos = new Vector(prevPos);
        partialPos.add(deltaPos);
        Quaternion prevRot = prev.createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        Quaternion curRot = cur.createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        Quaternion partialRot = Quaternion.slerpInterpolate(prevRot, curRot, partialTick);
        double[] partialAngles = partialRot.toRadians();
        this.renderTransform = new ShipTransform(partialPos.X, partialPos.Y, partialPos.Z, Math.toDegrees(partialAngles[0]), Math.toDegrees(partialAngles[1]), Math.toDegrees(partialAngles[2]), this.parent.getCenterCoord());
    }
}

