/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.management;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.physmanagement.chunk.VSChunkClaim;

public class WorldPhysObjectManager {
    public final World worldObj;
    public final Set<PhysicsWrapperEntity> physicsEntities;
    private final Long2ObjectMap<PhysicsWrapperEntity> chunkPosToPhysicsEntityMap;

    public WorldPhysObjectManager(World toManage) {
        this.worldObj = toManage;
        this.physicsEntities = ConcurrentHashMap.newKeySet();
        this.chunkPosToPhysicsEntityMap = new Long2ObjectOpenHashMap();
    }

    public List<PhysicsWrapperEntity> getTickablePhysicsEntities() {
        ArrayList<PhysicsWrapperEntity> list = new ArrayList<PhysicsWrapperEntity>(this.physicsEntities);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PhysicsWrapperEntity wrapperEntity = (PhysicsWrapperEntity)((Object)iterator.next());
            if (wrapperEntity.getPhysicsObject().isFullyLoaded()) continue;
            iterator.remove();
        }
        return list;
    }

    public void onLoad(PhysicsWrapperEntity loaded) {
        if (loaded.field_70170_p.field_72995_K) {
            ArrayList<PhysicsWrapperEntity> potentialMatches = new ArrayList<PhysicsWrapperEntity>();
            for (PhysicsWrapperEntity wrapper : this.physicsEntities) {
                if (!wrapper.getPersistentID().equals(loaded.getPersistentID())) continue;
                potentialMatches.add(wrapper);
            }
            for (PhysicsWrapperEntity caught : potentialMatches) {
                this.physicsEntities.remove((Object)caught);
                caught.getPhysicsObject().onThisUnload();
            }
        }
        loaded.field_70128_L = false;
        loaded.getPhysicsObject().resetConsecutiveProperTicks();
        this.physicsEntities.add(loaded);
    }

    public void preloadPhysicsWrapperEntityMappings(PhysicsWrapperEntity loaded) {
        for (int x = loaded.getPhysicsObject().getOwnedChunks().minX(); x <= loaded.getPhysicsObject().getOwnedChunks().maxX(); ++x) {
            for (int z = loaded.getPhysicsObject().getOwnedChunks().minZ(); z <= loaded.getPhysicsObject().getOwnedChunks().maxZ(); ++z) {
                this.chunkPosToPhysicsEntityMap.put(this.getLongFromInts(x, z), (Object)loaded);
            }
        }
    }

    public void onUnload(PhysicsWrapperEntity loaded) {
        if (!loaded.field_70170_p.field_72995_K) {
            this.physicsEntities.remove((Object)loaded);
            loaded.getPhysicsObject().onThisUnload();
            VSChunkClaim vsChunkClaim = loaded.getPhysicsObject().getOwnedChunks();
            for (int chunkX = vsChunkClaim.minX(); chunkX <= vsChunkClaim.maxX(); ++chunkX) {
                for (int chunkZ = vsChunkClaim.minZ(); chunkZ <= vsChunkClaim.maxZ(); ++chunkZ) {
                    this.chunkPosToPhysicsEntityMap.remove(this.getLongFromInts(chunkX, chunkZ));
                }
            }
        } else {
            loaded.field_70128_L = true;
            loaded.getPhysicsObject().onThisUnload();
        }
        this.physicsEntities.remove((Object)loaded);
        ArrayList keysToRemove = new ArrayList();
        for (Map.Entry entry : this.chunkPosToPhysicsEntityMap.entrySet()) {
            if (entry.getValue() != loaded) continue;
            keysToRemove.add(entry.getKey());
        }
        for (Long keyToRemove : keysToRemove) {
            this.chunkPosToPhysicsEntityMap.remove((Object)keyToRemove);
        }
        loaded.getPhysicsObject().resetConsecutiveProperTicks();
    }

    public List<PhysicsWrapperEntity> getNearbyPhysObjects(AxisAlignedBB toCheck) {
        ArrayList<PhysicsWrapperEntity> ships = new ArrayList<PhysicsWrapperEntity>();
        AxisAlignedBB expandedCheck = toCheck.func_72321_a(6.0, 6.0, 6.0);
        for (PhysicsWrapperEntity wrapper : this.physicsEntities) {
            if (!wrapper.getPhysicsObject().isFullyLoaded() || !wrapper.getPhysicsObject().getShipBoundingBox().func_72321_a(2.0, 2.0, 2.0).func_72326_a(expandedCheck)) continue;
            ships.add(wrapper);
        }
        return ships;
    }

    private long getLongFromInts(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }
}

