/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics.management.chunkcache;

import java.util.Map;
import java.util.Optional;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.fixes.IPhysicsChunk;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physics.management.chunkcache.ChunkNotInClaimException;
import org.valkyrienskies.mod.common.physmanagement.chunk.VSChunkClaim;

public class ClaimedChunkCacheController {
    private static final Logger log = LogManager.getLogger(ClaimedChunkCacheController.class);
    private final PhysicsObject parent;
    private final World world;
    private Chunk[][] claimedChunks;

    public ClaimedChunkCacheController(PhysicsObject parent, boolean loaded) {
        this.world = parent.world();
        this.parent = parent;
        int dimension = parent.getOwnedChunks().dimension();
        if (loaded) {
            this.loadLoadedChunks();
        } else {
            this.loadNewChunks();
        }
    }

    public Chunk getChunkAt(int chunkX, int chunkZ) {
        VSChunkClaim claim = this.parent.getOwnedChunks();
        ClaimedChunkCacheController.throwIfOutOfBounds(claim, chunkX, chunkZ);
        return this.getChunkRelative(chunkX - claim.minX(), chunkZ - claim.minZ());
    }

    public Chunk getChunkRelative(int relativeX, int relativeZ) {
        return this.claimedChunks[relativeX][relativeZ];
    }

    public void setChunkRelative(int relativeX, int relativeZ, Chunk chunk) {
        this.claimedChunks[relativeX][relativeZ] = chunk;
    }

    public void setChunkAt(int chunkX, int chunkZ, Chunk chunk) {
        VSChunkClaim claim = this.parent.getOwnedChunks();
        ClaimedChunkCacheController.throwIfOutOfBounds(claim, chunkX, chunkZ);
        this.setChunkRelative(chunkX - claim.minX(), chunkZ - claim.minZ(), chunk);
    }

    private static void throwIfOutOfBounds(VSChunkClaim claim, int chunkX, int chunkZ) {
        if (!claim.containsChunk(chunkX, chunkZ)) {
            throw new ChunkNotInClaimException(chunkX, chunkZ);
        }
    }

    @Deprecated
    public Chunk[][] getCacheArray() {
        return this.claimedChunks;
    }

    private void loadLoadedChunks() {
        VSChunkClaim chunkClaim = this.parent.getOwnedChunks();
        this.claimedChunks = new Chunk[chunkClaim.getRadius() * 2 + 1][chunkClaim.getRadius() * 2 + 1];
        for (int x = chunkClaim.minX(); x <= chunkClaim.maxX(); ++x) {
            for (int z = chunkClaim.minZ(); z <= chunkClaim.maxZ(); ++z) {
                try {
                    Chunk chunk = this.world.func_72964_e(x, z);
                    if (!this.world.field_72995_K) {
                        this.injectChunkIntoWorld(chunk, x, z, false);
                    }
                    for (Map.Entry entry : chunk.field_150816_i.entrySet()) {
                        this.parent.onSetTileEntity((BlockPos)entry.getKey(), (TileEntity)entry.getValue());
                    }
                    this.claimedChunks[x - chunkClaim.minX()][z - chunkClaim.minZ()] = chunk;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void loadNewChunks() {
        VSChunkClaim chunkClaim = this.parent.getOwnedChunks();
        this.claimedChunks = new Chunk[chunkClaim.getRadius() * 2 + 1][chunkClaim.getRadius() * 2 + 1];
        for (int x = chunkClaim.minX(); x <= chunkClaim.maxX(); ++x) {
            for (int z = chunkClaim.minZ(); z <= chunkClaim.maxZ(); ++z) {
                Chunk chunk = new Chunk(this.world, x, z);
                this.injectChunkIntoWorld(chunk, x, z, true);
                this.claimedChunks[x - chunkClaim.minX()][z - chunkClaim.minZ()] = chunk;
            }
        }
    }

    public void injectChunkIntoWorld(Chunk chunk, int x, int z, boolean putInId2ChunkMap) {
        VSChunkClaim chunkClaim = this.parent.getOwnedChunks();
        chunk.func_76603_b();
        chunk.func_150809_p();
        ((IPhysicsChunk)chunk).setParentPhysicsObject(Optional.of(this.parent));
        ChunkProviderServer provider = (ChunkProviderServer)this.world.func_72863_F();
        chunk.field_76643_l = true;
        this.claimedChunks[x - chunkClaim.minX()][z - chunkClaim.minZ()] = chunk;
        if (putInId2ChunkMap) {
            provider.field_73244_f.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)chunk);
        }
        chunk.func_76631_c();
        chunk.func_177446_d(true);
        chunk.func_177421_e(true);
        if (!((WorldServer)this.world).func_152345_ab()) {
            throw new IllegalThreadStateException("We cannot call this crap from another thread!");
        }
        PlayerChunkMap map = ((WorldServer)this.world).func_184164_w();
        PlayerChunkMapEntry entry = map.func_187302_c(x, z);
        entry.field_187290_j = true;
        entry.field_187283_c = this.parent.getWatchingPlayers();
    }
}

