/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physmanagement.chunk;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.physmanagement.chunk.PhysicsChunkManager;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public class DimensionPhysicsChunkManager {
    private final Map<World, PhysicsChunkManager> managerPerWorld = new HashMap<World, PhysicsChunkManager>();

    public void initWorld(World world) {
        if (!this.managerPerWorld.containsKey(world)) {
            System.out.println("Physics Chunk Manager Initialized");
            this.managerPerWorld.put(world, new PhysicsChunkManager(world));
        }
    }

    public PhysicsChunkManager getManagerForWorld(World world) {
        return this.managerPerWorld.get(world);
    }

    public void removeWorld(World world) {
        this.managerPerWorld.remove(world);
    }

    public void registerChunksForShip(PhysicsWrapperEntity wrapper) {
        ValkyrienUtils.getQueryableData(wrapper.field_70170_p).addShip(wrapper);
    }

    public void removeRegisteredChunksForShip(PhysicsWrapperEntity wrapper) {
        ValkyrienUtils.getQueryableData(wrapper.field_70170_p).removeShip(wrapper);
    }

    public void updateShipPosition(PhysicsWrapperEntity wrapper) {
        ValkyrienUtils.getQueryableData(wrapper.field_70170_p).updateShipPosition(wrapper);
    }

    public void removeShipPosition(PhysicsWrapperEntity wrapper) {
        ValkyrienUtils.getQueryableData(wrapper.field_70170_p).removeShip(wrapper);
    }

    public void removeShipNameRegistry(PhysicsWrapperEntity wrapper) {
        ValkyrienUtils.getQueryableData(wrapper.field_70170_p).removeShip(wrapper);
    }
}

