/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physmanagement.chunk;

import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShipChunkAllocator {
    private static final Logger log = LogManager.getLogger(ShipChunkAllocator.class);
    public static final int MAX_SHIP_CHUNK_LENGTH = 32;
    public static final int MAX_SHIP_CHUNK_RADIUS = 15;
    public static final int SHIP_CHUNK_X_START = 320000;
    public static final int SHIP_CHUNK_Z_START = 0;
    private int nextChunkX = 320000;
    private int nextChunkZ = 0;

    public static boolean isLikelyShipChunk(int chunkX, int chunkZ) {
        return chunkX >= 320000 && chunkZ >= 0;
    }

    public ChunkAllocation allocateChunks(String shipId, int chunkRadius) {
        if (chunkRadius > 15) {
            log.error(shipId + " just tried allocating chunks with a radius of: " + chunkRadius + "\nThis is just too big! Expect bad luck and decades of instability after this!");
            throw new RuntimeException(shipId + " just tried allocating chunks with a radius of: " + chunkRadius + "\nThis is just too big! Expect bad luck and decades of instability after this!");
        }
        return this.allocateNext();
    }

    private ChunkAllocation allocateNext() {
        ChunkAllocation next = new ChunkAllocation(this.nextChunkX, this.nextChunkZ);
        this.nextChunkZ += 32;
        return next;
    }

    public void writeToNBT(NBTTagCompound toReturn) {
        toReturn.func_74768_a("nextChunkX", this.nextChunkX);
        toReturn.func_74768_a("nextChunkZ", this.nextChunkZ);
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("nextChunkX") && compound.func_74764_b("nextChunkZ")) {
            this.nextChunkX = compound.func_74762_e("nextChunkX");
            this.nextChunkZ = compound.func_74762_e("nextChunkZ");
        } else {
            log.error("Either you created a new world, or Valkyrien Skies just lost track of every single ship chunk! If its case #2 then good luck dude your ships are screwed.");
            this.nextChunkX = 320000;
            this.nextChunkZ = 0;
        }
    }

    public static class ChunkAllocation {
        final int lowerChunkX;
        final int lowerChunkZ;

        private ChunkAllocation(int lowerChunkX, int lowerChunkZ) {
            this.lowerChunkX = lowerChunkX;
            this.lowerChunkZ = lowerChunkZ;
        }

        public boolean equals(Object other) {
            if (other instanceof ChunkAllocation) {
                ChunkAllocation otherChunk = (ChunkAllocation)other;
                return otherChunk.lowerChunkX == this.lowerChunkX && otherChunk.lowerChunkZ == this.lowerChunkZ;
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode((long)this.lowerChunkX << 32 | (long)this.lowerChunkZ & 0xFFFFFFFL);
        }
    }
}

