/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physmanagement.chunk;

import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

@Immutable
public final class VSChunkClaim {
    private final int centerX;
    private final int centerZ;
    private final int radius;

    public VSChunkClaim(NBTTagCompound readFrom) {
        this(readFrom.func_74762_e("centerX"), readFrom.func_74762_e("centerZ"), readFrom.func_74762_e("radius"));
    }

    public void writeToNBT(NBTTagCompound toSave) {
        toSave.func_74768_a("centerX", this.getCenterX());
        toSave.func_74768_a("centerZ", this.getCenterZ());
        toSave.func_74768_a("radius", this.getRadius());
    }

    public boolean containsChunk(int chunkX, int chunkZ) {
        boolean inX = chunkX >= this.minX() && chunkX <= this.maxX();
        boolean inZ = chunkZ >= this.minZ() && chunkZ <= this.maxZ();
        return inX && inZ;
    }

    public boolean containsChunk(ChunkPos pos) {
        return this.containsChunk(pos.field_77276_a, pos.field_77275_b);
    }

    public boolean containsBlock(BlockPos pos) {
        return this.containsChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public ChunkPos absoluteToRelative(ChunkPos pos) {
        return new ChunkPos(pos.field_77276_a - this.minX(), pos.field_77275_b - this.minZ());
    }

    public ChunkPos relativeToAbsolute(ChunkPos pos) {
        return new ChunkPos(pos.field_77276_a + this.minX(), pos.field_77275_b + this.minZ());
    }

    public String toString() {
        return this.getCenterX() + ":" + this.getCenterZ() + ":" + this.getRadius();
    }

    public Stream<ChunkPos> stream() {
        return Streams.stream((Iterator)new ChunkPosIterator());
    }

    public int maxX() {
        return this.getCenterX() + this.getRadius();
    }

    public int maxZ() {
        return this.getCenterZ() + this.getRadius();
    }

    public int minZ() {
        return this.getCenterZ() - this.getRadius();
    }

    public int minX() {
        return this.getCenterX() - this.getRadius();
    }

    public int dimension() {
        return this.getRadius() * 2 + 1;
    }

    public BlockPos regionCenter() {
        return new BlockPos(this.getCenterX() * 16, 128, this.getCenterZ() * 16);
    }

    public int chunkLengthX() {
        return this.maxX() - this.minX() + 1;
    }

    public int chunkLengthZ() {
        return this.maxZ() - this.minZ() + 1;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterZ() {
        return this.centerZ;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VSChunkClaim)) {
            return false;
        }
        VSChunkClaim other = (VSChunkClaim)o;
        if (this.getCenterX() != other.getCenterX()) {
            return false;
        }
        if (this.getCenterZ() != other.getCenterZ()) {
            return false;
        }
        return this.getRadius() == other.getRadius();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCenterX();
        result = result * 59 + this.getCenterZ();
        result = result * 59 + this.getRadius();
        return result;
    }

    public VSChunkClaim(int centerX, int centerZ, int radius) {
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.radius = radius;
    }

    private VSChunkClaim() {
        this.centerX = 0;
        this.centerZ = 0;
        this.radius = 0;
    }

    class ChunkPosIterator
    implements Iterator<ChunkPos> {
        int index = 0;

        ChunkPosIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < VSChunkClaim.this.dimension() * VSChunkClaim.this.dimension();
        }

        @Override
        public ChunkPos next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int x = this.index % VSChunkClaim.this.dimension() + VSChunkClaim.this.minX();
            int z = this.index / VSChunkClaim.this.dimension() + VSChunkClaim.this.minZ();
            ++this.index;
            return new ChunkPos(x, z);
        }
    }
}

