/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physmanagement.relocation;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.physmanagement.relocation.ShipBlockPosFinder;
import org.valkyrienskies.mod.common.physmanagement.relocation.ShipSpawnDetector;
import org.valkyrienskies.mod.common.physmanagement.relocation.SingleBlockPosDetector;
import org.valkyrienskies.mod.common.physmanagement.relocation.SpatialDetector;

public class DetectorManager {
    public static SpatialDetector getDetectorFor(int id, BlockPos start, World worldIn, int maximum, boolean checkCorners) {
        return DetectorManager.getDetectorFor(DetectorIDs.values()[id], start, worldIn, maximum, checkCorners);
    }

    public static SpatialDetector getDetectorFor(DetectorIDs id, BlockPos start, World worldIn, int maximum, boolean checkCorners) {
        switch (id) {
            case ShipSpawnerGeneral: {
                return new ShipSpawnDetector(start, worldIn, maximum, checkCorners);
            }
            case BlockPosFinder: {
                return new ShipBlockPosFinder(start, worldIn, maximum, checkCorners);
            }
            case SingleBlockPosFinder: {
                return new SingleBlockPosDetector(start, worldIn, maximum, checkCorners);
            }
        }
        throw new IllegalArgumentException("Unrecognized detector");
    }

    public static enum DetectorIDs {
        ShipSpawnerGeneral,
        BlockPosFinder,
        SingleBlockPosFinder;

    }
}

