/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physmanagement.relocation;

import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.valkyrienskies.addon.control.nodenetwork.IVSNodeProvider;
import org.valkyrienskies.mod.common.coordinates.CoordinateSpaceType;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physmanagement.relocation.IRelocationAwareTile;

public class MoveBlocks {
    public static void copyBlockToPos(World world, BlockPos oldPos, BlockPos newPos, Optional<PhysicsObject> physicsObjectOptional) {
        IBlockState oldState = world.func_180495_p(newPos);
        IBlockState newState = world.func_180495_p(oldPos);
        Chunk chunkToSet = world.func_175726_f(newPos);
        int storageIndex = newPos.func_177956_o() >> 4;
        if (storageIndex < 0 || storageIndex >= chunkToSet.field_76652_q.length) {
            return;
        }
        if (chunkToSet.field_76652_q[storageIndex] == Chunk.field_186036_a) {
            chunkToSet.field_76652_q[storageIndex] = new ExtendedBlockStorage(storageIndex << 4, true);
        }
        chunkToSet.field_76652_q[storageIndex].func_177484_a(newPos.func_177958_n() & 0xF, newPos.func_177956_o() & 0xF, newPos.func_177952_p() & 0xF, newState);
        world.func_184138_a(newPos, oldState, newState, 2);
        if (physicsObjectOptional.isPresent()) {
            int minChunkX = physicsObjectOptional.get().getOwnedChunks().minX();
            int n = physicsObjectOptional.get().getOwnedChunks().minZ();
        }
        MoveBlocks.copyTileEntityToPos(world, oldPos, newPos, physicsObjectOptional);
    }

    private static void copyTileEntityToPos(World world, BlockPos oldPos, BlockPos newPos, Optional<PhysicsObject> physicsObjectOptional) {
        TileEntity worldTile = world.func_175625_s(oldPos);
        if (worldTile != null) {
            TileEntity newInstance;
            NBTTagCompound tileEntNBT = new NBTTagCompound();
            if (worldTile instanceof IRelocationAwareTile) {
                CoordinateSpaceType coordinateSpaceType = physicsObjectOptional.isPresent() ? CoordinateSpaceType.SUBSPACE_COORDINATES : CoordinateSpaceType.GLOBAL_COORDINATES;
                ShipTransform transform = new ShipTransform(newPos.func_177958_n() - oldPos.func_177958_n(), newPos.func_177956_o() - oldPos.func_177956_o(), newPos.func_177952_p() - oldPos.func_177952_p());
                newInstance = ((IRelocationAwareTile)worldTile).createRelocatedTile(newPos, transform, coordinateSpaceType);
            } else {
                tileEntNBT = worldTile.func_189515_b(tileEntNBT);
                tileEntNBT.func_74768_a("x", newPos.func_177958_n());
                tileEntNBT.func_74768_a("y", newPos.func_177956_o());
                tileEntNBT.func_74768_a("z", newPos.func_177952_p());
                newInstance = TileEntity.func_190200_a((World)world, (NBTTagCompound)tileEntNBT);
            }
            if (newInstance instanceof IVSNodeProvider) {
                ((IVSNodeProvider)newInstance).shiftInternalData(newPos.func_177973_b((Vec3i)oldPos));
                if (physicsObjectOptional.isPresent()) {
                    ((IVSNodeProvider)newInstance).getNode().setParentPhysicsObject(physicsObjectOptional.get());
                } else {
                    ((IVSNodeProvider)newInstance).getNode().setParentPhysicsObject(null);
                }
            }
            try {
                world.func_175690_a(newPos, newInstance);
                physicsObjectOptional.ifPresent(physicsObject -> physicsObject.onSetTileEntity(newPos, newInstance));
                newInstance.func_70296_d();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

