/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physmanagement.relocation;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.physmanagement.relocation.SpatialDetector;

public class ShipSpawnDetector
extends SpatialDetector {
    private static final Set<Block> blacklist = new CopyOnWriteArraySet<Block>();
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    private static void syncWithConfig() {
        blacklist.clear();
        Arrays.stream(VSConfig.shipSpawnDetectorBlacklist).map(Block::func_149684_b).forEach(blacklist::add);
    }

    ShipSpawnDetector(BlockPos start, World worldIn, int maximum, boolean checkCorners) {
        super(start, worldIn, maximum, checkCorners);
        this.startDetection();
    }

    @Override
    public boolean isValidExpansion(int x, int y, int z) {
        this.mutablePos.func_181079_c(x, y, z);
        IBlockState state = this.cache.func_180495_p((BlockPos)this.mutablePos);
        if (state.func_177230_c() == Blocks.field_150357_h) {
            this.cleanHouse = true;
            return false;
        }
        return !blacklist.contains(state.func_177230_c());
    }

    static {
        VSConfig.registerSyncEvent(ShipSpawnDetector::syncWithConfig);
        ShipSpawnDetector.syncWithConfig();
    }
}

