/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physmanagement.shipdata;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableList;
import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.index.unique.UniqueIndex;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.StringStartsWith;
import com.googlecode.cqengine.resultset.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.physmanagement.shipdata.ShipData;
import org.valkyrienskies.mod.common.physmanagement.shipdata.ShipPositionData;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

@MethodsReturnNonnullByDefault
public class QueryableShipData
implements Iterable<ShipData> {
    private static final String NBT_STORAGE_KEY = "valkyrienskiesQueryableShipDataNBT";
    private ConcurrentIndexedCollection<ShipData> allShips = new ConcurrentIndexedCollection();

    public QueryableShipData() {
        this.allShips.addIndex(HashIndex.onAttribute(ShipData.NAME));
        this.allShips.addIndex(UniqueIndex.onAttribute(ShipData.UUID));
        this.allShips.addIndex(UniqueIndex.onAttribute(ShipData.CHUNKS));
    }

    public static QueryableShipData get(World world) {
        return ValkyrienUtils.getQueryableData(world);
    }

    public boolean renameShip(ShipData data, String newName) {
        Equal<ShipData, String> query = QueryFactory.equal(ShipData.NAME, newName);
        if (this.allShips.retrieve(query).isEmpty()) {
            ShipData newData = new ShipData.Builder(data).setName(newName).build();
            this.allShips.remove(data);
            this.allShips.add(newData);
            return true;
        }
        return false;
    }

    public Stream<ShipData> getShipsFromNameStartingWith(String startsWith) {
        StringStartsWith<ShipData, String> query = QueryFactory.startsWith(ShipData.NAME, startsWith);
        return this.allShips.retrieve(query).stream();
    }

    public List<ShipData> getShips() {
        return ImmutableList.copyOf(this.allShips);
    }

    public Optional<ShipData> getShipFromChunk(int chunkX, int chunkZ) {
        return this.getShipFromChunk(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
    }

    public Optional<ShipData> getShipFromChunk(long chunkLong) {
        Equal<ShipData, Long> query = QueryFactory.equal(ShipData.CHUNKS, chunkLong);
        ResultSet<ShipData> resultSet = this.allShips.retrieve(query);
        if (resultSet.size() > 1) {
            throw new IllegalStateException("How the heck did we get 2 or more ships both managing the chunk at " + chunkLong);
        }
        if (resultSet.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(resultSet.uniqueResult());
    }

    public Optional<ShipData> getShip(UUID uuid) {
        Equal<ShipData, UUID> query = QueryFactory.equal(ShipData.UUID, uuid);
        ResultSet<ShipData> resultSet = this.allShips.retrieve(query);
        if (resultSet.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(resultSet.uniqueResult());
    }

    public Optional<ShipData> getShip(PhysicsWrapperEntity wrapperEntity) {
        return this.getShip(wrapperEntity.getPersistentID());
    }

    public ShipData getOrCreateShip(PhysicsWrapperEntity wrapperEntity) {
        Optional<ShipData> data = this.getShip(wrapperEntity.getPersistentID());
        return data.orElseGet(() -> {
            ShipData shipData = new ShipData.Builder(wrapperEntity).build();
            this.allShips.add(shipData);
            return shipData;
        });
    }

    public Optional<ShipData> getShipFromName(String name) {
        Equal<ShipData, String> query = QueryFactory.equal(ShipData.NAME, name);
        ResultSet<ShipData> shipDataResultSet = this.allShips.retrieve(query);
        if (shipDataResultSet.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(shipDataResultSet.uniqueResult());
    }

    public void removeShip(PhysicsWrapperEntity wrapper) {
        this.removeShip(wrapper.getPersistentID());
    }

    public void removeShip(UUID uuid) {
        Optional<ShipData> shipOptional = this.getShip(uuid);
        shipOptional.ifPresent(ship -> this.allShips.remove(ship));
    }

    public void addShip(ShipData ship) {
        this.allShips.add(ship);
    }

    public void addShip(PhysicsWrapperEntity wrapperEntity) {
        Equal<ShipData, UUID> query = QueryFactory.equal(ShipData.UUID, wrapperEntity.getPersistentID());
        if (this.allShips.retrieve(query).isEmpty()) {
            this.addShip(new ShipData.Builder(wrapperEntity).build());
        }
    }

    public void updateShipPosition(PhysicsWrapperEntity wrapper) {
        ShipData shipData = this.getOrCreateShip(wrapper);
        if (shipData.positionData == null) {
            shipData.positionData = new ShipPositionData(wrapper);
        }
        shipData.positionData.updateData(wrapper);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        long start = System.currentTimeMillis();
        Kryo kryo = ValkyrienSkiesMod.INSTANCE.getKryo();
        Input input = new Input(nbt.func_74770_j(NBT_STORAGE_KEY));
        try {
            this.allShips = kryo.readObject(input, ConcurrentIndexedCollection.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.allShips = new ConcurrentIndexedCollection();
        }
        if (this.allShips == null) {
            throw new IllegalStateException("Kryo read allships as null! Making a new empty allships instance");
        }
        System.out.println("Price of read: " + (System.currentTimeMillis() - start) + "ms");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        long start = System.currentTimeMillis();
        Kryo kryo = ValkyrienSkiesMod.INSTANCE.getKryo();
        Output output = new Output(1024, -1);
        kryo.writeObject(output, this.allShips);
        compound.func_74773_a(NBT_STORAGE_KEY, output.getBuffer());
        System.out.println("Price of write: " + (System.currentTimeMillis() - start) + "ms");
        return compound;
    }

    @Override
    public Iterator<ShipData> iterator() {
        return this.allShips.iterator();
    }

    public Stream<ShipData> stream() {
        return this.allShips.stream();
    }
}

