/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physmanagement.shipdata;

import com.google.common.collect.ImmutableSet;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.MultiValueAttribute;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.physmanagement.chunk.VSChunkClaim;
import org.valkyrienskies.mod.common.physmanagement.shipdata.ShipPositionData;

public final class ShipData {
    @Nullable
    public ShipPositionData positionData;
    private String name;
    private UUID uuid;
    private Set<Long> chunkLongs;
    private VSChunkClaim chunkClaim;
    static final Attribute<ShipData, String> NAME = QueryFactory.attribute(ship -> ship.name);
    static final Attribute<ShipData, UUID> UUID = QueryFactory.attribute(ship -> ship.uuid);
    static final Attribute<ShipData, Long> CHUNKS = new MultiValueAttribute<ShipData, Long>(){

        @Override
        public Set<Long> getValues(ShipData ship, QueryOptions queryOptions) {
            return ship.chunkLongs;
        }
    };

    @Nullable
    public ShipPositionData getPositionData() {
        return this.positionData;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Set<Long> getChunkLongs() {
        return this.chunkLongs;
    }

    public VSChunkClaim getChunkClaim() {
        return this.chunkClaim;
    }

    public static class Builder {
        private ShipData shipData;

        public Builder(ShipData data) {
            this.shipData = data;
        }

        public Builder(PhysicsWrapperEntity wrapperEntity) {
            this.shipData = new ShipData();
            this.shipData.name = wrapperEntity.func_95999_t();
            this.shipData.uuid = wrapperEntity.getPersistentID();
            this.shipData.chunkLongs = (Set)ImmutableSet.copyOf(Builder.getChunkLongs(wrapperEntity));
            this.shipData.chunkClaim = wrapperEntity.getPhysicsObject().getOwnedChunks();
        }

        public Builder() {
            this.shipData = new ShipData();
        }

        public ShipData build() {
            return this.shipData;
        }

        public Builder setName(String name) {
            this.shipData.name = name;
            return this;
        }

        public Builder setUUID(UUID uuid) {
            this.shipData.uuid = uuid;
            return this;
        }

        public Builder setChunkLongs(Set<Long> chunkLongs) {
            this.shipData.chunkLongs = Collections.unmodifiableSet(chunkLongs);
            return this;
        }

        public Builder setChunkClaim(VSChunkClaim chunkClaim) {
            this.shipData.chunkClaim = chunkClaim;
            return this;
        }

        private static Set<Long> getChunkLongs(PhysicsWrapperEntity entity) {
            HashSet<Long> chunkLongs = new HashSet<Long>();
            VSChunkClaim ownedChunks = entity.getPhysicsObject().getOwnedChunks();
            int centerX = ownedChunks.getCenterX();
            int centerZ = ownedChunks.getCenterZ();
            int radius = ownedChunks.getRadius();
            for (int x = centerX - radius; x <= centerX + radius; ++x) {
                for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                    long chunkPos = ChunkPos.func_77272_a((int)x, (int)z);
                    chunkLongs.add(chunkPos);
                }
            }
            return chunkLongs;
        }
    }
}

