/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physmanagement.shipdata;

import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Vector;

public class ShipPositionData {
    private final Vector shipPosition;
    private ShipTransform transform;

    ShipPositionData(PhysicsWrapperEntity wrapper) {
        this.shipPosition = new Vector(wrapper.field_70165_t, wrapper.field_70163_u, wrapper.field_70161_v);
        this.transform = wrapper.getPhysicsObject().getShipTransformationManager().getCurrentTickTransform();
    }

    void updateData(PhysicsWrapperEntity wrapper) {
        this.shipPosition.X = wrapper.field_70165_t;
        this.shipPosition.Y = wrapper.field_70163_u;
        this.shipPosition.Z = wrapper.field_70161_v;
        this.transform = wrapper.getPhysicsObject().getShipTransformationManager().getCurrentTickTransform();
    }

    public double getPosX() {
        return this.shipPosition.X;
    }

    public double getPosY() {
        return this.shipPosition.Y;
    }

    public double getPosZ() {
        return this.shipPosition.Z;
    }

    public ShipPositionData() {
        this.shipPosition = null;
    }

    public ShipTransform getTransform() {
        return this.transform;
    }
}

