/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ship_handling;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import org.valkyrienskies.mod.common.ship_handling.IShipChunkClaims;
import org.valkyrienskies.mod.common.ship_handling.IWorldShipManager;
import org.valkyrienskies.mod.common.ship_handling.ShipHolder;

public class ImplShipChunkClaims
implements IShipChunkClaims {
    private final Set<ChunkPos> claimedPositions = new TreeSet<ChunkPos>();
    private transient Map<Long, Chunk> loadedChunksMap;
    private transient IWorldShipManager worldShipManager;
    private transient ShipHolder shipHolder;

    protected ImplShipChunkClaims() {
    }

    @Override
    public void initializeTransients(IWorldShipManager worldShipManager, ShipHolder shipHolder) {
        if (this.loadedChunksMap != null || worldShipManager != null || shipHolder != null) {
            throw new IllegalStateException();
        }
        this.loadedChunksMap = new HashMap<Long, Chunk>();
        this.worldShipManager = worldShipManager;
        this.shipHolder = shipHolder;
    }

    @Override
    public Iterator<ChunkPos> getClaimedChunkPos() {
        return this.claimedPositions.iterator();
    }

    @Override
    public boolean isPosClaimed(ChunkPos pos) {
        return this.claimedPositions.contains(pos);
    }

    @Override
    public boolean removeClaim(ChunkPos pos) {
        return this.claimedPositions.remove(pos);
    }

    @Override
    public boolean loadAllChunkClaims() {
        for (ChunkPos chunkPos : this.claimedPositions) {
            Chunk chunk = this.getWorldObj().func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
            if (chunk == null) {
                System.out.println("Just a loaded a null chunk");
                chunk = new Chunk(this.getWorldObj(), chunkPos.field_77276_a, chunkPos.field_77275_b);
            }
            this.injectChunkIntoWorld(chunkPos.field_77276_a, chunkPos.field_77275_b, chunk);
        }
        return false;
    }

    @Override
    public boolean areChunkClaimsFullyLoaded() {
        return this.loadedChunksMap.keySet().size() == this.claimedPositions.size();
    }

    @Override
    public boolean claimPos(ChunkPos pos) {
        return this.claimedPositions.add(pos);
    }

    private void injectChunkIntoWorld(int x, int z, Chunk chunk) {
        ChunkProviderServer provider = (ChunkProviderServer)this.getWorldObj().func_72863_F();
        chunk.field_76643_l = true;
        this.loadedChunksMap.put(ChunkPos.func_77272_a((int)x, (int)z), chunk);
        provider.field_73244_f.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)chunk);
        chunk.func_76631_c();
        PlayerChunkMap map = ((WorldServer)this.getWorldObj()).func_184164_w();
        PlayerChunkMapEntry entry = new PlayerChunkMapEntry(map, x, z);
        long i = PlayerChunkMap.func_187307_d((int)x, (int)z);
        map.field_72700_c.put(i, (Object)entry);
        map.field_111193_e.add(entry);
        entry.field_187290_j = true;
        entry.field_187283_c = Collections.unmodifiableList(this.shipHolder.getWatchingPlayers());
    }

    private World getWorldObj() {
        return this.worldShipManager.getWorld();
    }
}

