/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ship_handling;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.ship_handling.IShipChunkClaims;
import org.valkyrienskies.mod.common.ship_handling.IWorldShipManager;

public class ShipHolder {
    private String shipID;
    private double shipPosX;
    private double shipPosY;
    private double shipPosZ;
    private IShipChunkClaims shipChunkClaims;
    private transient PhysicsObject ship;
    private transient List<EntityPlayerMP> watchingPlayers = new ArrayList<EntityPlayerMP>();
    private transient boolean isActive = false;
    private transient IWorldShipManager worldShipManager;

    protected void initializeTransients(IWorldShipManager worldShipManager) {
        this.worldShipManager = worldShipManager;
        this.shipChunkClaims.initializeTransients(worldShipManager, this);
    }

    protected boolean markShipAsActive() {
        if (!this.shipChunkClaims.areChunkClaimsFullyLoaded()) {
            this.shipChunkClaims.loadAllChunkClaims();
        } else {
            this.isActive = true;
        }
        return this.shipChunkClaims.areChunkClaimsFullyLoaded();
    }

    protected void markShipAsInactive() {
        this.isActive = false;
    }

    protected boolean isActive() {
        return this.isActive;
    }

    protected double getShipPosX() {
        return this.shipPosX;
    }

    protected double getShipPosZ() {
        return this.shipPosZ;
    }

    protected PhysicsObject getShip() {
        return this.ship;
    }

    protected List<EntityPlayerMP> getWatchingPlayers() {
        return this.watchingPlayers;
    }
}

