/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ship_handling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import org.valkyrienskies.mod.common.ship_handling.IQuickShipAccess;
import org.valkyrienskies.mod.common.ship_handling.ShipHolder;

public class SimpleQuickShipAccess
implements IQuickShipAccess {
    private final List<ShipHolder> ships = new ArrayList<ShipHolder>();

    @Override
    public Iterator<ShipHolder> getShipsIntersectingWith(AxisAlignedBB playerBB) {
        ArrayList ships = new ArrayList();
        for (ShipHolder shipHolder : ships) {
            if (shipHolder.getShip() == null) continue;
        }
        return ships.iterator();
    }

    @Override
    public void addShip(ShipHolder shipHolder) {
        this.ships.add(shipHolder);
    }

    @Override
    public void deleteShip(ShipHolder shipHolder) {
        this.ships.remove(shipHolder);
    }

    @Override
    public void updateShipPositions() {
    }

    @Override
    public Iterable<ShipHolder> activeShips() {
        ArrayList<ShipHolder> activeShips = new ArrayList<ShipHolder>();
        for (ShipHolder ship : this.ships) {
            if (!ship.isActive()) continue;
            activeShips.add(ship);
        }
        return activeShips;
    }

    @Override
    public Iterator<ShipHolder> getShipsNearby(int posX, int posZ, double range) {
        double rangeSq = range * range;
        ArrayList<ShipHolder> ships = new ArrayList<ShipHolder>();
        for (ShipHolder shipHolder : ships) {
            double distanceSq = (shipHolder.getShipPosX() - (double)posX) * (shipHolder.getShipPosX() - (double)posX) + (shipHolder.getShipPosZ() - (double)posZ) * (shipHolder.getShipPosZ() - (double)posZ);
            if (!(distanceSq < rangeSq)) continue;
            ships.add(shipHolder);
        }
        return ships.iterator();
    }
}

