/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ship_handling;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.multithreaded.VSThread;
import org.valkyrienskies.mod.common.ship_handling.IQuickShipAccess;
import org.valkyrienskies.mod.common.ship_handling.IWorldShipManager;
import org.valkyrienskies.mod.common.ship_handling.ShipHolder;
import org.valkyrienskies.mod.common.ship_handling.SimpleQuickShipAccess;

public class WorldServerShipManager
implements IWorldShipManager {
    private transient World world;
    private IQuickShipAccess shipAccess;
    private transient Map<EntityPlayer, List<ShipHolder>> playerToWatchingShips;
    private transient VSThread physicsThread;

    public WorldServerShipManager(World world) {
        this.world = world;
        this.playerToWatchingShips = new HashMap<EntityPlayer, List<ShipHolder>>();
        this.shipAccess = new SimpleQuickShipAccess();
        this.physicsThread = new VSThread(this.world);
        this.physicsThread.start();
    }

    @Override
    public void onWorldUnload() {
        this.world = null;
        this.playerToWatchingShips.clear();
        this.playerToWatchingShips = null;
        this.physicsThread.kill();
    }

    @Override
    public void tick() {
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    public VSThread getPhysicsThread() {
        return this.physicsThread;
    }
}

