/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.tileentity;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.valkyrienskies.fixes.VSNetwork;
import org.valkyrienskies.mod.client.gui.IVSTileGui;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.block.BlockPhysicsInfuser;
import org.valkyrienskies.mod.common.container.EnumInfuserButton;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.network.VSGuiButtonMessage;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physmanagement.chunk.PhysicsChunkManager;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public class TileEntityPhysicsInfuser
extends TileEntity
implements ITickable,
ICapabilityProvider,
IVSTileGui {
    private final ItemStackHandler handler = new ItemStackHandler(EnumInfuserCore.values().length){

        protected void onContentsChanged(int slot) {
            TileEntityPhysicsInfuser.this.sendUpdateToClients = true;
        }
    };
    private volatile boolean sendUpdateToClients = false;
    private volatile boolean isTryingToAssembleShip = false;
    private volatile boolean isTryingToDisassembleShip = false;
    private boolean isPhysicsEnabled = false;
    private boolean isTryingToAlignShip = false;
    private Map<EnumInfuserCore, Double> coreOffsets = new HashMap<EnumInfuserCore, Double>();
    private Map<EnumInfuserCore, Double> coreOffsetsPrevTick = new HashMap<EnumInfuserCore, Double>();

    public TileEntityPhysicsInfuser() {
        for (EnumInfuserCore enumInfuserCore : EnumInfuserCore.values()) {
            this.coreOffsets.put(enumInfuserCore, 0.0);
            this.coreOffsetsPrevTick.put(enumInfuserCore, 0.0);
        }
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            IBlockState infuserState;
            Optional<PhysicsObject> parentShip = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v(), false);
            if (!parentShip.isPresent() && (this.isPhysicsEnabled || this.isTryingToAlignShip)) {
                this.isPhysicsEnabled = false;
                this.isTryingToAlignShip = false;
                this.sendUpdateToClients = true;
            }
            if ((infuserState = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177230_c() == ValkyrienSkiesMod.INSTANCE.physicsInfuser) {
                IBlockState newState;
                if (this.isPhysicsEnabled() && this.canMaintainShip()) {
                    if (!((Boolean)infuserState.func_177229_b((IProperty)BlockPhysicsInfuser.INFUSER_LIGHT_ON)).booleanValue()) {
                        newState = infuserState.func_177226_a((IProperty)BlockPhysicsInfuser.INFUSER_LIGHT_ON, (Comparable)Boolean.valueOf(true));
                        this.func_145831_w().func_175656_a(this.func_174877_v(), newState);
                    }
                } else if (((Boolean)infuserState.func_177229_b((IProperty)BlockPhysicsInfuser.INFUSER_LIGHT_ON)).booleanValue()) {
                    newState = infuserState.func_177226_a((IProperty)BlockPhysicsInfuser.INFUSER_LIGHT_ON, (Comparable)Boolean.valueOf(false));
                    this.func_145831_w().func_175656_a(this.func_174877_v(), newState);
                }
            }
            if (!parentShip.isPresent() && this.canMaintainShip() && this.isTryingToAssembleShip && !PhysicsChunkManager.isLikelyShipChunk(this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4)) {
                try {
                    WorldServer gameTickThread = (WorldServer)this.field_145850_b;
                    PhysicsWrapperEntity.createWrapperEntity(this, ((BlockPhysicsInfuser)infuserState.func_177230_c()).getShipSpawnDetectorID()).thenAcceptTickSync(ship -> {
                        System.out.println("Spawning ship entity in thread " + Thread.currentThread().getName());
                        this.func_145831_w().func_72838_d((Entity)ship);
                    }, (IThreadListener)gameTickThread);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.sendUpdateToClients) {
                VSNetwork.sendTileToAllNearby(this);
                this.sendUpdateToClients = false;
            }
        } else if (this.isPhysicsEnabled()) {
            long worldTime = this.func_145831_w().func_72820_D();
            for (EnumInfuserCore enumInfuserCore : EnumInfuserCore.values()) {
                this.coreOffsetsPrevTick.put(enumInfuserCore, this.coreOffsets.get((Object)enumInfuserCore));
                if (!this.handler.getStackInSlot(enumInfuserCore.coreSlotIndex).func_190926_b() && this.canMaintainShip()) {
                    double sinAngle = (double)(worldTime % 50L * 2L) * Math.PI / 50.0 + Math.PI * 2 / (double)EnumInfuserCore.values().length * (double)enumInfuserCore.coreSlotIndex;
                    double idealOffset = 0.025 * (Math.sin(sinAngle) + 1.0);
                    double lerpedOffset = 0.9 * this.coreOffsets.get((Object)enumInfuserCore) + 0.1 * idealOffset;
                    this.coreOffsets.put(enumInfuserCore, lerpedOffset);
                    continue;
                }
                this.coreOffsets.put(enumInfuserCore, 0.0);
            }
        } else {
            for (EnumInfuserCore enumInfuserCore : EnumInfuserCore.values()) {
                this.coreOffsetsPrevTick.put(enumInfuserCore, this.coreOffsets.get((Object)enumInfuserCore));
                double lerpedOffset = 0.95 * this.coreOffsets.get((Object)enumInfuserCore);
                this.coreOffsets.put(enumInfuserCore, lerpedOffset);
            }
        }
        this.isTryingToAssembleShip = false;
        this.isTryingToDisassembleShip = false;
    }

    public boolean canMaintainShip() {
        ItemStack mainStack = this.handler.getStackInSlot(EnumInfuserCore.MAIN.coreSlotIndex);
        return !mainStack.func_190926_b();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("item_stack_handler", (NBTBase)this.handler.serializeNBT());
        compound.func_74757_a("physics_enabled", this.isPhysicsEnabled);
        compound.func_74757_a("try_to_align_ship", this.isTryingToAlignShip);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.handler.deserializeNBT(compound.func_74775_l("item_stack_handler"));
        this.isPhysicsEnabled = compound.func_74767_n("physics_enabled");
        this.isTryingToAlignShip = compound.func_74767_n("try_to_align_ship");
        super.func_145839_a(compound);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @MethodsReturnNonnullByDefault
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        Block blockType = this.func_145838_q();
        int blockMeta = this.func_145832_p();
        if (blockType instanceof BlockPhysicsInfuser) {
            IBlockState blockState = blockType.func_176203_a(blockMeta);
            EnumFacing sideFacing = ((BlockPhysicsInfuser)blockType).getDummyStateFacing(blockState);
            return new AxisAlignedBB(this.func_174877_v()).func_72321_a((double)(-sideFacing.func_82601_c()), (double)(-sideFacing.func_96559_d()), (double)(-sideFacing.func_82599_e())).func_72321_a(0.0, 0.3, 0.0);
        }
        return super.getRenderBoundingBox();
    }

    public boolean isCurrentlyInShip() {
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v());
        return physicsObject.isPresent();
    }

    @Override
    public void onButtonPress(int buttonId, EntityPlayer presser) {
        if (buttonId >= EnumInfuserButton.values().length) {
            return;
        }
        EnumInfuserButton button = EnumInfuserButton.values()[buttonId];
        this.sendUpdateToClients = true;
        switch (button) {
            case ASSEMBLE_SHIP: {
                if (!this.isCurrentlyInShip()) {
                    this.isTryingToAssembleShip = true;
                    break;
                }
                this.isTryingToDisassembleShip = true;
                break;
            }
            case ENABLE_PHYSICS: {
                this.isPhysicsEnabled = !this.isPhysicsEnabled();
                break;
            }
            case ALIGN_SHIP: {
                boolean bl = this.isTryingToAlignShip = !this.isTryingToAlignShip();
            }
        }
        if (this.func_145831_w().field_72995_K) {
            ValkyrienSkiesMod.physWrapperNetwork.sendToServer((IMessage)new VSGuiButtonMessage(this, button.ordinal()));
        }
    }

    public boolean canShipBeDeconstructed() {
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v());
        return !physicsObject.isPresent() || physicsObject.get().canShipBeDeconstructed();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean isCenterOfShip() {
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v());
        return !physicsObject.isPresent() || physicsObject.get().getPhysicsInfuserPos().equals((Object)this.func_174877_v());
    }

    @SideOnly(value=Side.CLIENT)
    public double getCoreVerticalOffset(EnumInfuserCore enumInfuserCore, float partialTicks) {
        return (double)(1.0f - partialTicks) * this.coreOffsetsPrevTick.get((Object)enumInfuserCore) + (double)partialTicks * this.coreOffsets.get((Object)enumInfuserCore);
    }

    public boolean isTryingToAssembleShip() {
        return this.isTryingToAssembleShip;
    }

    public boolean isTryingToDisassembleShip() {
        return this.isTryingToDisassembleShip;
    }

    public boolean isPhysicsEnabled() {
        return this.isPhysicsEnabled;
    }

    public void setPhysicsEnabled(boolean isPhysicsEnabled) {
        this.isPhysicsEnabled = isPhysicsEnabled;
    }

    public boolean isTryingToAlignShip() {
        return this.isTryingToAlignShip;
    }

    public static enum EnumInfuserCore {
        ONE("physics_core_small1_geo", 0, 45, 22),
        TWO("physics_core_small2_geo", 1, 45, 54),
        MAIN("physics_core_main_geo", 2, 79, 54),
        FOUR("physics_core_small4_geo", 3, 112, 54),
        FIVE("physics_core_small3_geo", 4, 112, 22);

        public final String coreModelName;
        public final int coreSlotIndex;
        public final int guiXPos;
        public final int guiYPos;

        private EnumInfuserCore(String coreModelName, int coreSlotIndex, int guiXPos, int guiYPos) {
            this.coreModelName = coreModelName;
            this.coreSlotIndex = coreSlotIndex;
            this.guiXPos = guiXPos;
            this.guiYPos = guiYPos;
        }
    }
}

