/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import java.nio.ByteBuffer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import org.valkyrienskies.mod.common.math.Vector;

public class ValkyrienNBTUtils {
    public static void writeBlockPosToNBT(String name, BlockPos pos, NBTTagCompound compound) {
        compound.func_74768_a(name + "X", pos.func_177958_n());
        compound.func_74768_a(name + "Y", pos.func_177956_o());
        compound.func_74768_a(name + "Z", pos.func_177952_p());
    }

    public static BlockPos readBlockPosFromNBT(String name, NBTTagCompound compound) {
        int x = compound.func_74762_e(name + "X");
        int y = compound.func_74762_e(name + "Y");
        int z = compound.func_74762_e(name + "Z");
        return new BlockPos(x, y, z);
    }

    public static void write3x3MatrixToNBT(String name, double[] matrix, NBTTagCompound compound) {
        for (int i = 0; i < 9; ++i) {
            compound.func_74780_a(name + i, matrix[i]);
        }
    }

    public static double[] read3x3MatrixFromNBT(String name, NBTTagCompound compound) {
        double[] matrix = new double[9];
        for (int i = 0; i < 9; ++i) {
            matrix[i] = compound.func_74769_h(name + i);
        }
        return matrix;
    }

    public static void writeVectorToNBT(String name, Vector vector, NBTTagCompound compound) {
        compound.func_74780_a(name + "X", vector.X);
        compound.func_74780_a(name + "Y", vector.Y);
        compound.func_74780_a(name + "Z", vector.Z);
    }

    public static Vector readVectorFromNBT(String name, NBTTagCompound compound) {
        Vector vector = new Vector();
        vector.X = compound.func_74769_h(name + "X");
        vector.Y = compound.func_74769_h(name + "Y");
        vector.Z = compound.func_74769_h(name + "Z");
        return vector;
    }

    public static byte[] toByteArray(double[] doubleArray) {
        int times = 8;
        byte[] bytes = new byte[doubleArray.length * times];
        for (int i = 0; i < doubleArray.length; ++i) {
            ByteBuffer.wrap(bytes, i * times, times).putDouble(doubleArray[i]);
        }
        return bytes;
    }

    public static double[] toDoubleArray(byte[] byteArray) {
        int times = 8;
        double[] doubles = new double[byteArray.length / times];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = ByteBuffer.wrap(byteArray, i * times, times).getDouble();
        }
        return doubles;
    }

    public static void writeAABBToNBT(String name, AxisAlignedBB aabb, NBTTagCompound compound) {
        compound.func_74780_a(name + "minX", aabb.field_72340_a);
        compound.func_74780_a(name + "minY", aabb.field_72338_b);
        compound.func_74780_a(name + "minZ", aabb.field_72339_c);
        compound.func_74780_a(name + "maxX", aabb.field_72336_d);
        compound.func_74780_a(name + "maxY", aabb.field_72337_e);
        compound.func_74780_a(name + "maxZ", aabb.field_72334_f);
    }

    public static AxisAlignedBB readAABBFromNBT(String name, NBTTagCompound compound) {
        AxisAlignedBB aabb = new AxisAlignedBB(compound.func_74769_h(name + "minX"), compound.func_74769_h(name + "minY"), compound.func_74769_h(name + "minZ"), compound.func_74769_h(name + "maxX"), compound.func_74769_h(name + "maxY"), compound.func_74769_h(name + "maxZ"));
        return aabb;
    }
}

