/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.fixes.IPhysicsChunk;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.coordinates.CoordinateSpaceType;
import org.valkyrienskies.mod.common.entity.EntityMountable;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physmanagement.shipdata.IValkyrienSkiesWorldData;
import org.valkyrienskies.mod.common.physmanagement.shipdata.QueryableShipData;
import org.valkyrienskies.mod.common.util.EntityShipMountData;
import valkyrienwarfare.api.TransformType;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class ValkyrienUtils {
    public static Optional<PhysicsObject> getPhysicsObject(@Nullable World world, @Nullable BlockPos pos) {
        return ValkyrienUtils.getPhysicsObject(world, pos, false);
    }

    public static Optional<PhysicsObject> getPhysicsObject(@Nullable World world, @Nullable BlockPos pos, boolean includePartiallyLoaded) {
        IPhysicsChunk physicsChunk;
        Optional<PhysicsObject> physicsObject;
        if (world != null && pos != null && world.func_175667_e(pos) && (physicsObject = (physicsChunk = (IPhysicsChunk)world.func_175726_f(pos)).getPhysicsObjectOptional()).isPresent() && (includePartiallyLoaded || physicsObject.get().isFullyLoaded())) {
            return physicsObject;
        }
        return Optional.empty();
    }

    public static AxisAlignedBB getAABBInGlobal(AxisAlignedBB axisAlignedBB, @Nullable World world, @Nullable BlockPos pos) {
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(world, pos);
        if (physicsObject.isPresent()) {
            Polygon bbAsPoly = new Polygon(axisAlignedBB, physicsObject.get().getShipTransformationManager().getCurrentTickTransform(), TransformType.SUBSPACE_TO_GLOBAL);
            return bbAsPoly.getEnclosedAABB();
        }
        return axisAlignedBB;
    }

    public static EntityShipMountData getMountedShipAndPos(Entity entity) {
        EntityMountable mountable;
        Optional<PhysicsObject> mountedShip;
        Entity ridingEntity = entity.field_184239_as;
        if (ridingEntity instanceof EntityMountable && (mountedShip = (mountable = (EntityMountable)ridingEntity).getMountedShip()).isPresent()) {
            return new EntityShipMountData(mountedShip.get(), mountable.getMountPos());
        }
        return new EntityShipMountData();
    }

    public static void fixEntityToShip(Entity toFix, Vector posInLocal, PhysicsObject mountingShip) {
        World world = mountingShip.world();
        EntityMountable entityMountable = new EntityMountable(world, posInLocal.toVec3d(), CoordinateSpaceType.SUBSPACE_COORDINATES, mountingShip.getReferenceBlockPos());
        world.func_72838_d((Entity)entityMountable);
        toFix.func_184220_m((Entity)entityMountable);
    }

    public static QueryableShipData getQueryableData(World world) {
        IValkyrienSkiesWorldData worldData = (IValkyrienSkiesWorldData)world.getCapability(ValkyrienSkiesMod.VS_WORLD_DATA, null);
        if (worldData == null) {
            throw new IllegalStateException("World " + world + " doesn't have an IVSWorldDataCapability. This is wrong!");
        }
        return worldData.getQueryableShipData();
    }

    private ValkyrienUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

