
// DevelAPITestDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "DevelAPITest.h"
#include "DevelAPITestDlg.h"
#include "DlgUserProp.h"

CDevelAPITestDlg::CDevelAPITestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDevelAPITestDlg::IDD, pParent)
{
	m_pUser = NULL;
	m_pCall = NULL;
}

void CDevelAPITestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LSTUSER, m_LstUser);
}

BEGIN_MESSAGE_MAP(CDevelAPITestDlg, CDialog)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTNLOGIN, OnBtnLogin)
	ON_BN_CLICKED(IDC_BTNLOADUSER, OnBtnLoadUser)
	ON_BN_CLICKED(IDC_BTNADDUSER, OnBtnAddUser)
	ON_BN_CLICKED(IDC_BTNDELUSER, OnBtnDelUser)
	ON_BN_CLICKED(IDC_BTNADDTIME, OnBtnAddTime)
	ON_BN_CLICKED(IDC_BTNPUTINFO, OnBtnPutInfo)
	ON_BN_CLICKED(IDC_BTNPUTUDATA, OnBtnPutUdata)
	ON_BN_CLICKED(IDC_BTNGETUDATA, OnBtnGetUdata)
	ON_BN_CLICKED(IDC_BTNPUTSDATA, OnBtnPutSdata)
	ON_BN_CLICKED(IDC_BTNGETSDATA, OnBtnGetSdata)
END_MESSAGE_MAP()

BOOL CDevelAPITestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	::CoInitialize(NULL);
	m_pUser.CreateInstance(__uuidof(UserInfo));
	m_pCall.CreateInstance(__uuidof(DevelCall));

	m_LstUser.InsertColumn(0, "û", DT_LEFT, 80);
	m_LstUser.InsertColumn(1, "", DT_LEFT, 80);
	m_LstUser.InsertColumn(2, "״̬", DT_LEFT, 40);
	m_LstUser.InsertColumn(3, "", DT_LEFT, 40);
	m_LstUser.InsertColumn(4, "ע/Ч", DT_LEFT, 80);
	m_LstUser.InsertColumn(5, "", DT_LEFT, 40);
	m_LstUser.InsertColumn(6, "", DT_LEFT, 40);

	m_LstUser.SetExtendedStyle(m_LstUser.GetExtendedStyle() | LVS_EX_FULLROWSELECT);

	return TRUE;
}

void CDevelAPITestDlg::OnDestroy()
{
	CDialog::OnDestroy();

	m_pUser.Release();
	m_pCall.Release();
	::CoUninitialize();
}

void CDevelAPITestDlg::OnBtnLogin()
{
	char szAcc[32];
	GetDlgItem(IDC_EDTACC)->GetWindowText(szAcc, sizeof(szAcc));

	char szPwd[32];
	GetDlgItem(IDC_EDTPWD)->GetWindowText(szPwd, sizeof(szPwd));
	m_pCall->Login(_bstr_t(szAcc), _bstr_t(szPwd));
}

void CDevelAPITestDlg::OnBtnLoadUser()
{
	int count = m_pCall->LoadUsers();
	m_LstUser.DeleteAllItems();

	for(int i = 0; i < count; ++i)
	{
		m_pCall->GetUserInfo(i, m_pUser);
		if(0 == m_pUser->ID) break;
		
		char szPwd[16];
		strcpy(szPwd, m_pUser->pwd);

		char szTime[16];
		strcpy(szTime, m_pUser->validtime);
		InsertUser(i, m_pUser->ID, m_pUser->name, szPwd, m_pUser->bind, m_pUser->point, m_pUser->type, m_pUser->state, szTime);
	}
}

void CDevelAPITestDlg::OnBtnAddUser()
{
	CDlgUserProp dlg;
			
	if(IDOK == dlg.DoModal())
	{
		DWORD UID = m_pCall->AddUser(dlg.m_name.GetBuffer(), dlg.m_pwd.GetBuffer(), dlg.m_bind, dlg.m_point, dlg.m_type);
		if(0 != UID)
		{
			int nItem = m_LstUser.GetItemCount();
			InsertUser(nItem, UID, dlg.m_name.GetBuffer(), dlg.m_pwd.GetBuffer(), dlg.m_bind, dlg.m_point, dlg.m_type);
		}
	}
}

void CDevelAPITestDlg::OnBtnDelUser()
{
	for(UINT nIndex = 0; nIndex < m_LstUser.GetItemCount(); )
	{
		if(LVIS_SELECTED == m_LstUser.GetItemState(nIndex, LVIS_SELECTED))
		{
			m_pCall->DelUser(m_LstUser.GetItemData(nIndex));
			m_LstUser.DeleteItem(nIndex);
		}
		else
		{
			++nIndex;
		}
	}
}

void CDevelAPITestDlg::OnBtnAddTime()
{
	short day;
	for(UINT nIndex = 0; nIndex < m_LstUser.GetItemCount(); ++nIndex)
	{
		if(LVIS_SELECTED == m_LstUser.GetItemState(nIndex, LVIS_SELECTED))
		{
			day = 10;
			if(0 == m_pCall->ChangeTime(m_LstUser.GetItemData(nIndex), &day))
			{
				char text[256];
				m_pCall->GetUserInfo(nIndex, m_pUser);
				if(0 != m_pUser->state) m_LstUser.SetItemText(nIndex, 4, m_pUser->validtime);
				
				sprintf(text, "%s ʱɹ : %d", (char*)m_pUser->name, day);
				GetDlgItem(IDC_EDTRET)->SetWindowText(text);
			}
			else
			{
				GetDlgItem(IDC_EDTRET)->SetWindowText("ʱʧ");
			}
			break;
		}
	}
}

void CDevelAPITestDlg::OnBtnPutInfo()
{
	for(UINT nIndex = 0; nIndex < m_LstUser.GetItemCount(); ++nIndex)
	{
		if(LVIS_SELECTED == m_LstUser.GetItemState(nIndex, LVIS_SELECTED))
		{
			m_pCall->GetUserInfo(nIndex, m_pUser);

			CDlgUserProp dlg;
			dlg.m_name  = (char*)m_pUser->name;
			dlg.m_pwd   = (char*)m_pUser->pwd;
			dlg.m_type  = m_pUser->type;
			dlg.m_bind  = m_pUser->bind;
			dlg.m_point = m_pUser->point;
			
			if(IDOK == dlg.DoModal())
			{
				m_pUser->name  = dlg.m_name.GetBuffer();
				m_pUser->pwd   = dlg.m_pwd.GetBuffer();
				m_pUser->type  = dlg.m_type;
				m_pUser->bind  = dlg.m_bind;
				m_pUser->point = dlg.m_point;

				if(0 == m_pCall->PutUserInfo(m_pUser))
				{
					SetItemInfo(nIndex, dlg.m_name.GetBuffer(), dlg.m_pwd.GetBuffer(), dlg.m_bind, dlg.m_point, dlg.m_type);
				}
			}
			break;
		}
	}
}

void CDevelAPITestDlg::OnBtnPutUdata()
{
	for(UINT nIndex = 0; nIndex < m_LstUser.GetItemCount(); ++nIndex)
	{
		if(LVIS_SELECTED == m_LstUser.GetItemState(nIndex, LVIS_SELECTED))
		{
			m_pCall->PutUserData(m_LstUser.GetItemData(nIndex), _bstr_t("00000000000000000000000000000000"));
			break;
		}
	}
}

void CDevelAPITestDlg::OnBtnGetUdata()
{
	for(UINT nIndex = 0; nIndex < m_LstUser.GetItemCount(); ++nIndex)
	{
		if(LVIS_SELECTED == m_LstUser.GetItemState(nIndex, LVIS_SELECTED))
		{
			BSTR val = m_pCall->GetUserData(m_LstUser.GetItemData(nIndex));
			break;
		}
	}
}

void CDevelAPITestDlg::OnBtnPutSdata()
{
	m_pCall->PutSerialData(_bstr_t("{38AA60AC-CEF3-4D35-AB5A-5F69D8C65ECA}"), _bstr_t("00000000000000000000000000000001"));
}

void CDevelAPITestDlg::OnBtnGetSdata()
{
	BSTR val = m_pCall->GetSerialData(_bstr_t("{38AA60AC-CEF3-4D35-AB5A-5F69D8C65ECA}"));
}

void CDevelAPITestDlg::InsertUser(int nItem, DWORD UID, char* name, char* pwd, BYTE bind, short point, BYTE type, BYTE state, char* time)
{
	m_LstUser.InsertItem(nItem, name);
	m_LstUser.SetItemData(nItem, UID);
	
	SetItemInfo(nItem, name, pwd, bind, point, type);

	char val[16];
	itoa(state, val, 10);
	m_LstUser.SetItemText(nItem, 2, val);

	if(NULL == time)
	{
		m_LstUser.SetItemText(nItem, 4, COleDateTime::GetCurrentTime().Format("%Y-%m-%d"));
	}
	else
	{
		m_LstUser.SetItemText(nItem, 4, time);
	}
}

void CDevelAPITestDlg::SetItemInfo(int nItem, char* name, char* pwd, BYTE bind, short point, BYTE type)
{
	m_LstUser.SetItemText(nItem, 0, name);
	m_LstUser.SetItemText(nItem, 1, pwd);

	char val[16];
	itoa(bind, val, 10);
	m_LstUser.SetItemText(nItem, 3, val);

	itoa(point, val, 10);
	m_LstUser.SetItemText(nItem, 5, val);

	itoa(type, val, 10);
	m_LstUser.SetItemText(nItem, 6, val);
}
