﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using AllpurAuthenticLib;

namespace CNetTest
{   
    public partial class frmInit : Form
    {
        public frmInit()
        {
            InitializeComponent();
        }

        private void frmInit_Load(object sender, EventArgs e)
        {
            cboMode.Items.Add("注册码模式");
            cboMode.Items.Add("用户模式");
            cboMode.SelectedIndex = 0;

            frmMain.AuthObj = this.AuthObj;
            this.Text = "V盾网络验证--" + AuthObj.GetVersion();
            AuthObj.Initialize(); //初始验证组件
        }

        private void btnTest_Click(object sender, EventArgs e)
        {
            int ret = AuthObj.Auth("你的产品编号", "你的产品编号, 就是试用卡号");
            if(0 == ret)
            {
                Hide();
                frmMain.ShowDialog();
                Close();
            }
            else
            {
                lblRet.Text = "试用卡已过期";
            }
        }

        private void btnAuth_Click(object sender, EventArgs e)
        {
            int ret = 0;
            if (0 == cboMode.SelectedIndex) //注册码模式
            {
                ret = AuthObj.Auth("你的产品编号", txtAcc.Text);
            }
            else
            {
                ret = AuthObj.UserAuth("你的产品编号", txtAcc.Text, txtPwd.Text);
            }

            switch(ret)
            {
            case 0:
                Hide();
                frmMain.ShowDialog();
                Close();
                break;
            case -1:
                lblRet.Text = "注册码不存在";
                break;
            case -2:
                lblRet.Text = "注册码被禁用";
                break;
            case -3:
                lblRet.Text = "绑定机器超限";
                break;
            case -4:
                lblRet.Text = "注册码已在线";
                break;
            case -5:
                lblRet.Text = "已过期";
                break;
            case -6:
                lblRet.Text = "用户余额不足";
                break;
            }
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void btnRegister_Click(object sender, EventArgs e)
        {
            Byte  type = 0; //用户类型, 也可以是其它值(0到15均可), 类型由作者自己定义
            Byte  bind = 0; //绑机台数, 0为不绑机, 0到5均可
            short point = 0; //给用户的点数, 0到8000

            if(0 == AuthObj.UserRegister("你的产品编号", txtName.Text, txtPassword.Text, type, bind, point))
            {
                LblRet2.Text = "注册成功";
            }
            else
            {
                LblRet2.Text = "注册失败";
            }
        }

        private void btnPay_Click(object sender, EventArgs e)
        {
            short days  = 0;
            short point = 0;
            if(0 == AuthObj.AddTime("你的产品编号", txtCard.Text, txtUser.Text, out days, out point))
            {
                lblRet3.Text = "加时成功!增加天数:" + days.ToString() + "增加点数:" + point.ToString();
            }
            else
            {
                lblRet3.Text = "加时失败";
            }
        }

        public  FrmMain      frmMain = new FrmMain();
        private CurrencyAuth AuthObj = new CurrencyAuth();
    }
}
