﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using AllpurAuthenticLib;

namespace CNetTest
{
    public partial class FrmMain : Form
    {
        public FrmMain()
        {
            InitializeComponent();
        }

        private void FrmMain_Load(object sender, EventArgs e)
        {
            //事件接收函数设置
            _ICurrencyAuthEvents_OnUpdateEventHandler OnUpdateHandler = new _ICurrencyAuthEvents_OnUpdateEventHandler(AuthObj_OnUpdate);
            AuthObj.OnUpdate += OnUpdateHandler;

            _ICurrencyAuthEvents_OnBulletinEventHandler OnBulletinHandler = new _ICurrencyAuthEvents_OnBulletinEventHandler(AuthObj_OnBulletin);
            AuthObj.OnBulletin += OnBulletinHandler;

            _ICurrencyAuthEvents_OnInvalidEventHandler OnInvalidHandler = new _ICurrencyAuthEvents_OnInvalidEventHandler(AuthObj_OnInvalid);
            AuthObj.OnInvalid += OnInvalidHandler;

            //主窗口内所有插件功能均必须验证成功后方可调用
            //验证成功后即可获取到有效期、校验码、公告
            txtValidity.Text = AuthObj.GetValidity();
            txtCode.Text = AuthObj.GetCode();
            txtBulletin.Text = AuthObj.GetBulletin();

            //其它线程的调用，可使UI刷新
            System.Windows.Forms.Control.CheckForIllegalCrossThreadCalls = false;
        }

        private void btnAddPoint_Click(object sender, EventArgs e)
        {
            //扣除点数，这里扣除5点
            AuthObj.DeductPoint(5);
        }

        private void btnChangePwd_Click(object sender, EventArgs e)
        {
            //更改密码
            AuthObj.ChangePassword("旧密码", "新密码");
        }

        private void btnUserData_Click(object sender, EventArgs e)
        {
            //获取用户数据, 注册码和用户均可具有16字节的数据
            byte [] data = new byte[16];
            for(byte i = 0; i < 16; ++i)
            {
                data[i] = AuthObj.GetData(i);
            }

            //设置用户数据, 字符串长度为32字节,用来表示16字节的16进制数据
            AuthObj.PutData("05AF93......");
        }

        private void btnProductData_Click(object sender, EventArgs e)
        {
            ushort size = AuthObj.GetProductDataSize();
            byte [] data = new byte[size];
            for (ushort i = 0; i < size; ++i)
            {
                data[i] = AuthObj.GetProductData(i);
            }
        }

        private void btnUnbind_Click(object sender, EventArgs e)
        {
            //用户自解绑
            AuthObj.Unbind();
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            //调用Update后的过程: 退出本程序->替换已下载的文件->重启本程序
            AuthObj.Update();
        }

        private void AuthObj_OnUpdate()
        {
            btnUpdate.Enabled = true;
        }

        private void AuthObj_OnBulletin(string text)
        {
            txtBulletin.Text = text;
        }

        private void AuthObj_OnInvalid()
        {
            //变为无效状态后验证组件会30秒后主动关闭程序
            MessageBox.Show("已变为无效状态, 程序将在30秒后退出", "提示", MessageBoxButtons.OK, MessageBoxIcon.Question);
        }

        public CurrencyAuth AuthObj;
    }
}
