﻿
Public Class FrmInit
    Public frmMain As New FrmMain
    Private Sub FrmInit_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        cboMode.Items.Add("注册码模式")
        cboMode.Items.Add("用户模式")
        cboMode.SelectedIndex = 0

        txtAcc.Text = "{A88621CB-88AB-415F-9125-7CCFC4DE90A7}"

        AuthObj = New AllpurAuthenticLib.CurrencyAuth
        Me.Text = "V盾网络验证--" + AuthObj.GetVersion
        AuthObj.Initialize() '初始验证组件
    End Sub

    Private Sub cboMode_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cboMode.SelectedIndexChanged
        If (0 = cboMode.SelectedIndex) Then
            lblAcc.Text = "注册码"
            txtPwd.Visible = False
            lblPwd.Visible = False
        Else
            lblAcc.Text = "用户名"
            txtPwd.Visible = True
            lblPwd.Visible = True
        End If
    End Sub

    Private Sub btnTest_Click(sender As Object, e As EventArgs) Handles btnTest.Click
        Dim ret As Integer = AuthObj.Auth("你的产品编号", "你的产品编号")
        If 0 = ret Then
            Me.Hide()
            frmMain.ShowDialog()
            Me.Close()
        Else
            lblRet.Text = "试用失效"
        End If
    End Sub

    Private Sub btnAuth_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnAuth.Click
        Dim ret As Integer = 0
        If (0 = cboMode.SelectedIndex) Then '注册码模式
            ret = AuthObj.Auth("你的产品编号", txtAcc.Text)
        Else '用户模式
            ret = AuthObj.UserAuth("你的产品编号", txtAcc.Text, txtPwd.Text)
        End If

        Select Case ret
            Case 0
                Me.Hide()
                frmMain.ShowDialog()
                Me.Close()
            Case -1
                lblRet.Text = "注册码不存在"
            Case -2
                lblRet.Text = "注册码被禁用"
            Case -3
                lblRet.Text = "绑定机器超限"
            Case -4
                lblRet.Text = "注册码已在线"
            Case -5
                lblRet.Text = "已过期"
            Case -6
                lblRet.Text = "用户余额不足"
        End Select
    End Sub

    Private Sub btnExit_Click(sender As Object, e As EventArgs) Handles btnExit.Click
        Me.Close()
    End Sub

    Private Sub btnRegister_Click(sender As Object, e As EventArgs) Handles btnRegister.Click
        Dim type As Byte = 0 '用户类型, 也可以是其它值(0到15均可), 类型由作者自己定义
        Dim bind As Byte = 0 '绑机台数, 0为不绑机, 0到5均可
        Dim point As Short = 0 '给用户的点数, 0到8000

        If 0 = AuthObj.UserRegister("你的产品编号", txtName.Text, txtPassword.Text, type, bind, point) Then
            LblRet2.Text = "注册成功"
        Else
            LblRet2.Text = "注册失败"
        End If
    End Sub

    Private Sub btnPay_Click(sender As Object, e As EventArgs) Handles btnPay.Click
        Dim days As Short
        Dim point As Short
        If 0 = AuthObj.AddTime("你的产品编号", txtCard.Text, txtUser.Text, days, point) Then
            lblRet3.Text = "加时成功!增加天数:" + days.ToString() + "增加点数:" + point.ToString()
        Else
            lblRet3.Text = "加时失败"
        End If
    End Sub
End Class
