﻿
Public Class FrmMain
    Public WithEvents AuthObj As AllpurAuthenticLib.CurrencyAuth

    Private Sub FrmMain_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        '主窗口内所有插件功能均必须验证成功后方可调用
        '验证成功后即可获取到有效期、校验码、公告
        Me.AuthObj = ModuleGlobal.AuthObj

        Timer1.Start()
        txtValidity.Text = AuthObj.GetValidity()
        txtCode.Text = AuthObj.GetCode()
        txtBulletin.Text = AuthObj.GetBulletin()

        Dim s1 As String = AuthObj.Encrypt(0, "{7D465FAB-6893-4E03-B0DD-084B230FE0E9}", "abc")
        Dim s2 As String = AuthObj.Encrypt(1, s1, "")
        Dim s3 As String = AuthObj.Encrypt(0, s2, "123")

        '其它线程的调用，可使UI刷新
        System.Windows.Forms.Control.CheckForIllegalCrossThreadCalls = False
    End Sub

    Private Sub btnAddPoint_Click(sender As Object, e As EventArgs) Handles btnAddPoint.Click
        '扣除点数，这里扣掉5点
        AuthObj.DeductPoint(5)
    End Sub

    Private Sub btnChangePwd_Click(sender As Object, e As EventArgs) Handles btnChangePwd.Click
        '更改密码
        AuthObj.ChangePassword("旧密码", "新密码")
    End Sub

    Private Sub btnUserData_Click(sender As Object, e As EventArgs) Handles btnUserData.Click
        '获取用户数据, 注册码和用户均可具有16字节的数据
        Dim data(16) As Byte
        For i As Byte = 0 To 15
            data(i) = AuthObj.GetData(i)
        Next i

        '设置用户数据, 字符串长度为32字节,用来表示16字节的16进制数据
        AuthObj.PutData("05AF93......")
    End Sub

    Private Sub btnProductData_Click(sender As Object, e As EventArgs) Handles btnProductData.Click
        '获取产品数据, 产品数据在作者端上传文件即可, 最长允许64000字节
        Dim size As UShort = AuthObj.GetProductDataSize()
        Dim data(size) As Byte
        For i As Integer = 0 To size - 1
            data(i) = AuthObj.GetProductData(i)
        Next i
    End Sub

    Private Sub btnUnbind_Click(sender As Object, e As EventArgs) Handles btnUnbind.Click
        '用户解绑
        AuthObj.Unbind()
    End Sub

    Private Sub btnUpdate_Click(sender As Object, e As EventArgs) Handles btnUpdate.Click
        '调用Update后的过程: 退出本程序->替换已下载的文件->重启本程序
        AuthObj.Update()
    End Sub

    '以下是V盾验证组件的三个事件
    Private Sub AuthObj_OnUpdate() Handles AuthObj.OnUpdate
        '已下载完更新
        btnUpdate.Enabled = True
    End Sub

    Private Sub AuthObj_OnBulletin(ByVal text As String) Handles AuthObj.OnBulletin
        '收到公告
        txtBulletin.Text = text
    End Sub

    Private Sub AuthObj_OnInvalid() Handles AuthObj.OnInvalid
        '变为无效状态
        MsgBox("已变为无效状态, 程序将在30秒后退出") '变为无效状态后验证组件会30秒后主动关闭程序
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        If 0 <> StrComp(AuthObj.GetCode(), "{78466751-B648-CC82-87AA-48AAC75112D0}") Then
            Dim s As String = AuthObj.GetBulletin()
            s = ""
        End If
    End Sub

    Private size As UShort
    Private data(10000) As Byte
End Class