#include "stdafx.h"
#include "VCTest.h"
#include "DlgLogin.h"
#include "DlgTest.h"

IMPLEMENT_DYNAMIC(CDlgLogin, CDialog)

CDlgLogin::CDlgLogin(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgLogin::IDD, pParent)
{
}

CDlgLogin::~CDlgLogin()
{
}

void CDlgLogin::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CBOMODE, m_CboMode);
}

BEGIN_MESSAGE_MAP(CDlgLogin, CDialog)
	ON_BN_CLICKED(IDC_BTNLOGIN, &CDlgLogin::OnBtnLogin)
	ON_BN_CLICKED(IDC_BTNEXIT, &CDlgLogin::OnBtnExit)
	ON_BN_CLICKED(IDC_BTNTEST, &CDlgLogin::OnBtnTest)
	ON_CBN_SELCHANGE(IDC_CBOMODE, &CDlgLogin::OnSelChangeCboMode)
END_MESSAGE_MAP()

BOOL CDlgLogin::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_CboMode.AddString("עģʽ");
	m_CboMode.AddString("ûģʽ");
	m_CboMode.SetCurSel(0);

	return TRUE;
}

void CDlgLogin::OnBtnLogin()
{
	char szAcc[40];
	GetDlgItem(IDC_EDTACC)->GetWindowText(szAcc, sizeof(szAcc));

	int ret = 0;
	if(0 == m_CboMode.GetCurSel())//עģʽ
	{
		ret = pAuth->Auth(_bstr_t("ĲƷ"), _bstr_t(szAcc));
	}
	else//ûģʽ
	{
		char szPwd[16];
		GetDlgItem(IDC_EDTPWD)->GetWindowText(szPwd, sizeof(szPwd));
		ret = pAuth->UserAuth(_bstr_t("ĲƷ"), _bstr_t(szAcc), _bstr_t(szPwd));
	}

	switch(ret)
	{
	case 0:
		((CDlgTest*)theApp.m_pMainWnd)->OnOK();
		break;
	case -1:
		GetDlgItem(IDC_RET)->SetWindowText("ע벻");
		break;
	case -2:
		GetDlgItem(IDC_RET)->SetWindowText("ע뱻");
		break;
	case -3:
		GetDlgItem(IDC_RET)->SetWindowText("󶨻");
		break;
	case -4:
		GetDlgItem(IDC_RET)->SetWindowText("ע");
		break;
	case -5:
		GetDlgItem(IDC_RET)->SetWindowText("ѹ");
		break;
	case -6:
		GetDlgItem(IDC_RET)->SetWindowText("û");
		break;
	}
}

void CDlgLogin::OnBtnExit()
{
	theApp.m_pMainWnd->PostMessage(WM_CLOSE, 0, 0);
}

void CDlgLogin::OnBtnTest()
{
	int ret = pAuth->Auth(_bstr_t("ĲƷ"), _bstr_t("ĲƷ, ÿ"));
	if(0 == ret)
	{
		((CDlgTest*)theApp.m_pMainWnd)->OnOK();
	}
	else
	{
		GetDlgItem(IDC_RET)->SetWindowText("ÿѹ");
	}
}

void CDlgLogin::OnSelChangeCboMode()
{
	if(0 == m_CboMode.GetCurSel())
	{
		GetDlgItem(IDC_LBLACC)->SetWindowText("    ע");
		GetDlgItem(IDC_EDTPWD)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_LBLPWD)->ShowWindow(SW_HIDE);
	}
	else
	{
		GetDlgItem(IDC_LBLACC)->SetWindowText("    û");
		GetDlgItem(IDC_EDTPWD)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_LBLPWD)->ShowWindow(SW_SHOW);
	}
}
