// DlgMain.cpp : ʵļ
//

#include "stdafx.h"
#include "VCTest.h"
#include "DlgMain.h"

IMPLEMENT_DYNAMIC(CDlgMain, CDialog)

CDlgMain::CDlgMain(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgMain::IDD, pParent)
{
	m_pSink = NULL;
	m_pConnectionPointContainer = NULL;
	m_pConnectionPoint = NULL;
}

CDlgMain::~CDlgMain()
{
}

void CDlgMain::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CDlgMain, CDialog)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTNCHANGEPWD, &CDlgMain::OnBtnChangePwd)
	ON_BN_CLICKED(IDC_BTNDEDUCTPOINT, &CDlgMain::OnBtnDeductPoint)
	ON_BN_CLICKED(IDC_BTNUSERDATA, &CDlgMain::OnBtnUserData)
	ON_BN_CLICKED(IDC_BTNPRODUCTDATA, &CDlgMain::OnBtnProductData)
	ON_BN_CLICKED(IDC_BTNUNBIND, &CDlgMain::OnBtnUnbind)
	ON_BN_CLICKED(IDC_BTNUPDATE, &CDlgMain::OnBtnUpdate)
END_MESSAGE_MAP()

BOOL CDlgMain::OnInitDialog()
{
	CDialog::OnInitDialog();

	//вܾ֤ɹ󷽿ɵ
	//֤ɹ󼴿ɻȡЧڡУ롢
	GetDlgItem(IDC_EDTVALIDITY)->SetWindowText((char*)pAuth->GetValidity());
	GetDlgItem(IDC_EDTCODE)->SetWindowText((char*)pAuth->GetCode());
	GetDlgItem(IDC_EDTBULLETIN)->SetWindowText((char*)pAuth->GetBulletin());

	//±ߴڹҽӵ, COM¼
	m_pSink = new CSink;
	m_pSink->m_pEvent = static_cast<IEventAuth*>(this);
	m_pSink->AddRef();

	pAuth->QueryInterface(IID_IConnectionPointContainer, (void**)&m_pConnectionPointContainer);
	m_pConnectionPointContainer->FindConnectionPoint(DIID__ICurrencyAuthEvents, &m_pConnectionPoint);
	m_pConnectionPoint->Advise((IUnknown*)m_pSink, &m_dwCookie);

	return TRUE;
}

void CDlgMain::OnDestroy()
{
	CDialog::OnDestroy();

	m_pConnectionPoint->Unadvise(m_dwCookie);
	m_pConnectionPoint->Release();
	m_pConnectionPointContainer->Release();
	delete m_pSink;
}

void CDlgMain::OnBtnChangePwd()
{
	//޸
	pAuth->ChangePassword("", "");
}

void CDlgMain::OnBtnDeductPoint()
{
	//۵5, ʣ
	short point = pAuth->DeductPoint(5);
}

void CDlgMain::OnBtnUserData()
{
	//ȡû, עûɾ16ֽڵ
	BYTE data[16];
	for(int i = 0; i < 16; ++i)
	{
		data[i] = pAuth->GetData(i);
	}

	//û, ַΪ32ֽ,ʾ16ֽڵ16
//	pAuth->PutData("05AF93......");
}

void CDlgMain::OnBtnProductData()
{
	//ȡƷ, Ʒ߶ϴļ, 64000ֽ
	USHORT size = pAuth->GetProductDataSize();
	BYTE* pData = (BYTE*)alloca(size);
	for(USHORT i = 0; i < size; ++i)
	{
		pData[i] = pAuth->GetProductData(i);
	}
}

void CDlgMain::OnBtnUnbind()
{
	//û, 0ʾɹ
	int ret = pAuth->Unbind();
}

void CDlgMain::OnBtnUpdate()
{
	//UpdateĹ: ˳->滻صļ->
	pAuth->Update();
}

void CDlgMain::OnEvent(long dispID, tagDISPPARAMS* pParams)
{
	//յ֤¼
	switch(dispID)
	{
	case 1: //ԶصtempĿ¼, Update滻²
		GetDlgItem(IDC_BTNUPDATE)->EnableWindow(TRUE);
		break;
	case 2:	//ΪЧ״̬, 30˳
		::MessageBox(NULL, "˿ʧЧ, ϵ߻!", "ʾ", MB_OK);
		break;
	case 3:	//յ
		GetDlgItem(IDC_EDTBULLETIN)->SetWindowText(_bstr_t(pParams->rgvarg[0].bstrVal));
		break;
	}

	PostMessage(WM_PAINT, 0, 0);
}
