// DlgTest.cpp : ʵļ
//

#include "stdafx.h"
#include "VCTest.h"
#include "DlgTest.h"

IMPLEMENT_DYNAMIC(CDlgTest, CDialog)

CDlgTest::CDlgTest(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgTest::IDD, pParent)
{
	m_arrDlg[0] = &m_DlgLogin;
	m_arrDlg[1] = &m_DlgRegister;
	m_arrDlg[2] = &m_DlgPay;
}

CDlgTest::~CDlgTest()
{
}

void CDlgTest::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB, m_Tab);
}

BEGIN_MESSAGE_MAP(CDlgTest, CDialog)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB, &CDlgTest::OnTabChangeSel)
END_MESSAGE_MAP()

BOOL CDlgTest::OnInitDialog()
{
	CDialog::OnInitDialog();

	//ȡ֤汾, ˲ʡ
	char szTitle[64];
	sprintf(szTitle, "V֤--%s", (char*)pAuth->GetVersion());
	SetWindowText(szTitle);

	m_Tab.InsertItem(0, "¼");
	m_Tab.InsertItem(1, "ע");
	m_Tab.InsertItem(2, "ʱ");

	m_arrDlg[0]->Create(CDlgLogin::IDD, GetDlgItem(IDC_TAB));
	m_arrDlg[1]->Create(CDlgRegister::IDD, GetDlgItem(IDC_TAB));
	m_arrDlg[2]->Create(CDlgPay::IDD, GetDlgItem(IDC_TAB));

	RECT rc;
	m_Tab.GetClientRect(&rc);
	rc.top    += 20;
	rc.bottom -= 4;
	rc.left   += 4;
	rc.right  -= 4;

	m_arrDlg[0]->MoveWindow(&rc);
	m_arrDlg[1]->MoveWindow(&rc);
	m_arrDlg[2]->MoveWindow(&rc);

	m_DlgLogin.ShowWindow(TRUE);

	return TRUE;
}

void CDlgTest::OnTabChangeSel(NMHDR *pNMHDR, LRESULT *pResult)
{
	int sel = m_Tab.GetCurSel();
	for(int i = 0; i < m_Tab.GetItemCount(); ++i)
	{
		m_arrDlg[i]->ShowWindow(i == sel ? SW_SHOW : SW_HIDE);
	}

	*pResult = 0;
}

void CDlgTest::OnOK()
{
	CDialog::OnOK();

	CDlgMain DlgMain;
	theApp.m_pMainWnd = &DlgMain;
	DlgMain.DoModal();
}
