/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mrcrayfish.vehicle.client.render.Wheel;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public abstract class RenderVehicle<T extends EntityVehicle>
extends Render<T> {
    protected List<Wheel> wheels = new ArrayList<Wheel>();
    private PartPosition enginePosition = new PartPosition(0.0f, 0.0f, 0.0f, 0.0f, 1.0f);

    protected RenderVehicle(RenderManager renderManager) {
        super(renderManager);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(T entity) {
        return null;
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.wheels.forEach(wheel -> wheel.render((EntityVehicle)((Object)entity), partialTicks));
        if (((EntityVehicle)((Object)entity)).shouldRenderEngine()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)this.enginePosition.x * 0.0625), (double)((double)this.enginePosition.y * 0.0625), (double)((double)this.enginePosition.z * 0.0625));
            GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
            GlStateManager.func_179152_a((float)this.enginePosition.scale, (float)this.enginePosition.scale, (float)this.enginePosition.scale);
            GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
            GlStateManager.func_179114_b((float)this.enginePosition.rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(((EntityVehicle)((Object)entity)).engine, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
        }
    }

    public void setupBreakAnimation(EntityVehicle vehicle, float partialTicks) {
        float timeSinceHit = (float)vehicle.getTimeSinceHit() - partialTicks;
        float damageTaken = vehicle.getDamageTaken() - partialTicks;
        if (damageTaken < 0.0f) {
            damageTaken = 0.0f;
        }
        if (timeSinceHit > 0.0f) {
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)timeSinceHit) * timeSinceHit * damageTaken / 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public void setEnginePosition(float x, float y, float z, float rotation, float scale) {
        this.enginePosition.x = x;
        this.enginePosition.y = y;
        this.enginePosition.z = z;
        this.enginePosition.rotation = rotation;
        this.enginePosition.scale = scale;
    }

    private static class PartPosition {
        private float x;
        private float y;
        private float z;
        private float rotation;
        private float scale;

        public PartPosition(float x, float y, float z, float rotation, float scale) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.rotation = rotation;
            this.scale = scale;
        }
    }
}

