/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mrcrayfish.vehicle.entity.EntityVehicle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;

public class Wheel {
    private float offsetX;
    private float offsetZ;
    private float width;
    private float scale;
    private Side side;
    private Position position;

    public Wheel(Side side, Position position, float width, float scale, float offsetX, float offsetZ) {
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
        this.width = width;
        this.scale = scale;
        this.side = side;
        this.position = position;
    }

    public Wheel(Side side, Position position, float offsetX, float offsetZ) {
        this(side, position, 2.0f, 1.0f, offsetX, offsetZ);
    }

    public Wheel(Side side, Position position, float offsetX, float offsetZ, float scale) {
        this(side, position, 2.0f, scale, offsetX, offsetZ);
    }

    public void render(EntityVehicle vehicle, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.offsetX / 16.0f * (float)this.side.offset), (float)0.0f, (float)(this.offsetZ / 16.0f));
        GlStateManager.func_179094_E();
        if (this.position == Position.FRONT) {
            float wheelAngle = vehicle.prevWheelAngle + (vehicle.wheelAngle - vehicle.prevWheelAngle) * partialTicks;
            GlStateManager.func_179114_b((float)wheelAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (vehicle.isMoving()) {
            GlStateManager.func_179114_b((float)(-this.getWheelRotation(vehicle, partialTicks)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179109_b((float)(this.width * this.scale / 2.0f / 16.0f * (float)this.side.offset), (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        if (this.side == Side.RIGHT) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        Minecraft.func_71410_x().func_175599_af().func_181564_a(vehicle.wheel, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private float getWheelRotation(EntityVehicle vehicle, float partialTicks) {
        if (this.position == Position.REAR) {
            return vehicle.prevRearWheelRotation + (vehicle.rearWheelRotation - vehicle.prevRearWheelRotation) * partialTicks;
        }
        return vehicle.prevFrontWheelRotation + (vehicle.frontWheelRotation - vehicle.prevFrontWheelRotation) * partialTicks;
    }

    public static enum Position {
        FRONT,
        REAR,
        NONE;

    }

    public static enum Side {
        LEFT(-1),
        RIGHT(1),
        NONE(0);

        int offset;

        private Side(int offset) {
            this.offset = offset;
        }
    }
}

