/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public enum EngineType {
    POOR(0.75f, -2.0f, 0.0f, "Wood", TextFormatting.WHITE),
    BASIC(1.0f, 0.0f, 0.0f, "Stone", TextFormatting.DARK_GRAY),
    ADVANCED(1.25f, 1.0f, 0.0f, "Iron", TextFormatting.GRAY),
    STREET(1.5f, 3.0f, 0.0f, "Gold", TextFormatting.GOLD),
    RACING(1.1f, 6.0f, 0.0f, "Diamond", TextFormatting.AQUA);

    float accelerationMultiplier;
    float additionalMaxSpeed;
    float fuelConsumption;
    String tierName;
    TextFormatting tierColor;

    private EngineType(float accelerationMultiplier, float additionalMaxSpeed, float fuelConsumption, String tierName, TextFormatting tierColor) {
        this.accelerationMultiplier = accelerationMultiplier;
        this.additionalMaxSpeed = additionalMaxSpeed;
        this.fuelConsumption = fuelConsumption;
        this.tierName = tierName;
        this.tierColor = tierColor;
    }

    public float getAccelerationMultiplier() {
        return this.accelerationMultiplier;
    }

    public float getAdditionalMaxSpeed() {
        return this.additionalMaxSpeed;
    }

    public float getFuelConsumption() {
        return this.fuelConsumption;
    }

    public String getTierName() {
        return this.tierName;
    }

    public TextFormatting getTierColor() {
        return this.tierColor;
    }

    public static EngineType getType(ItemStack stack) {
        return EngineType.getType(stack.func_77952_i());
    }

    public static EngineType getType(int index) {
        if (index < 0 || index >= EngineType.values().length) {
            return POOR;
        }
        return EngineType.values()[index];
    }
}

