/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAccelerating;
import com.mrcrayfish.vehicle.network.message.MessageDrift;
import com.mrcrayfish.vehicle.network.message.MessageHorn;
import com.mrcrayfish.vehicle.network.message.MessageTurn;
import com.mrcrayfish.vehicle.proxy.ClientProxy;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehicle
extends Entity {
    private static final DataParameter<Float> CURRENT_SPEED = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MAX_SPEED = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ACCELERATION_SPEED = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TURN_DIRECTION = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TURN_SENSITIVITY = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DRIFTING = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ACCELERATION_DIRECTION = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> ENGINE_TYPE = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HORN = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187198_h);
    public float prevCurrentSpeed;
    public float currentSpeed;
    public float speedMultiplier;
    public int turnAngle;
    public int prevTurnAngle;
    public float wheelAngle;
    public float prevWheelAngle;
    public float frontWheelRotation;
    public float prevFrontWheelRotation;
    public float rearWheelRotation;
    public float prevRearWheelRotation;
    public float deltaYaw;
    public float additionalYaw;
    public float prevAdditionalYaw;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    @SideOnly(value=Side.CLIENT)
    public ItemStack body;
    @SideOnly(value=Side.CLIENT)
    public ItemStack wheel;
    @SideOnly(value=Side.CLIENT)
    public ItemStack engine;

    protected EntityVehicle(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70138_W = 1.0f;
    }

    public EntityVehicle(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    public abstract SoundEvent getMovingSound();

    public abstract SoundEvent getRidingSound();

    public SoundEvent getHornSound() {
        return ModSounds.HORN_MONO;
    }

    public SoundEvent getHornRidingSound() {
        return ModSounds.HORN_STEREO;
    }

    public float getMinEnginePitch() {
        return 0.5f;
    }

    public float getMaxEnginePitch() {
        return 1.2f;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(CURRENT_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(MAX_SPEED, (Object)Float.valueOf(10.0f));
        this.field_70180_af.func_187214_a(ACCELERATION_SPEED, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(TURN_DIRECTION, (Object)TurnDirection.FORWARD.ordinal());
        this.field_70180_af.func_187214_a(TURN_SENSITIVITY, (Object)10);
        this.field_70180_af.func_187214_a(DRIFTING, (Object)false);
        this.field_70180_af.func_187214_a(ACCELERATION_DIRECTION, (Object)AccelerationDirection.NONE.ordinal());
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ENGINE_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(HORN, (Object)false);
        if (this.field_70170_p.field_72995_K) {
            this.engine = new ItemStack(ModItems.ENGINE);
        }
    }

    public void func_70071_h_() {
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        super.func_70071_h_();
        if (this.func_184179_bs() != null) {
            this.tickLerp();
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.prevCurrentSpeed = this.currentSpeed;
        this.prevTurnAngle = this.turnAngle;
        this.prevWheelAngle = this.wheelAngle;
        this.prevFrontWheelRotation = this.frontWheelRotation;
        this.prevRearWheelRotation = this.rearWheelRotation;
        this.prevAdditionalYaw = this.additionalYaw;
        if (this.field_70170_p.field_72995_K) {
            this.onClientUpdate();
        }
        if (this.func_184179_bs() != null) {
            this.createParticles();
        }
        this.currentSpeed = this.getSpeed();
        this.updateSpeed();
        this.updateDrifting();
        this.updateWheels();
        this.currentSpeed += this.currentSpeed * this.speedMultiplier;
        this.setSpeed(this.currentSpeed);
        this.field_70181_x -= 0.08;
        this.field_70177_z -= this.deltaYaw;
        this.func_191958_b(0.0f, 0.0f, this.currentSpeed, 0.01f);
        this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)Math.abs(this.currentSpeed), this.field_70181_x, this.field_70179_y * (double)Math.abs(this.currentSpeed));
        this.field_70159_w *= 0.8;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= 0.8;
        this.speedMultiplier = (float)((double)this.speedMultiplier * 0.85);
        this.func_145775_I();
    }

    private void updateSpeed() {
        EngineType engineType = this.getEngineType();
        AccelerationDirection acceleration = this.getAcceleration();
        if (this.func_184179_bs() != null) {
            if (acceleration == AccelerationDirection.FORWARD) {
                this.currentSpeed += this.getAccelerationSpeed() * engineType.getAccelerationMultiplier();
                if (this.currentSpeed > this.getMaxSpeed() + engineType.getAdditionalMaxSpeed()) {
                    this.currentSpeed = this.getMaxSpeed() + engineType.getAdditionalMaxSpeed();
                }
            } else if (acceleration == AccelerationDirection.REVERSE) {
                this.currentSpeed -= this.getAccelerationSpeed() * engineType.getAccelerationMultiplier();
                if (this.currentSpeed < -(4.0f + engineType.getAdditionalMaxSpeed() / 2.0f)) {
                    this.currentSpeed = -(4.0f + engineType.getAdditionalMaxSpeed() / 2.0f);
                }
            } else {
                this.currentSpeed = (float)((double)this.currentSpeed * 0.9);
            }
        } else {
            this.currentSpeed = (float)((double)this.currentSpeed * 0.5);
        }
    }

    private void updateDrifting() {
        TurnDirection turnDirection = this.getTurnDirection();
        if (this.func_184179_bs() != null && this.isDrifting() && turnDirection != TurnDirection.FORWARD) {
            AccelerationDirection acceleration = this.getAcceleration();
            if (acceleration == AccelerationDirection.FORWARD) {
                this.currentSpeed *= 0.95f;
            }
            this.additionalYaw = MathHelper.func_76131_a((float)(this.additionalYaw + 5.0f * (float)turnDirection.getDir()), (float)-35.0f, (float)35.0f);
        } else {
            this.additionalYaw *= 0.85f;
        }
    }

    private void updateWheels() {
        TurnDirection direction = this.getTurnDirection();
        if (this.func_184179_bs() != null && direction != TurnDirection.FORWARD) {
            this.turnAngle += direction.dir * this.getTurnSensitivity();
            if (Math.abs(this.turnAngle) > 45) {
                this.turnAngle = 45 * direction.dir;
            }
        } else {
            this.turnAngle = (int)((double)this.turnAngle * 0.75);
        }
        float speedPercent = this.currentSpeed / this.getMaxSpeed();
        this.wheelAngle = (float)this.turnAngle * Math.max(0.25f, 1.0f - Math.abs(speedPercent));
        this.deltaYaw = this.wheelAngle * speedPercent / (this.isDrifting() ? 1.5f : 2.0f);
        AccelerationDirection acceleration = this.getAcceleration();
        if (this.func_184179_bs() != null && acceleration == AccelerationDirection.FORWARD) {
            this.rearWheelRotation = (float)((double)this.rearWheelRotation - 68.0 * (1.0 - (double)speedPercent));
        }
        this.frontWheelRotation -= 68.0f * speedPercent;
        this.rearWheelRotation -= 68.0f * speedPercent;
    }

    private void createParticles() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), z = MathHelper.func_76128_c((double)this.field_70161_v));
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_185904_a() != Material.field_151579_a && state.func_185904_a().func_76229_l() && this.getAcceleration() == AccelerationDirection.FORWARD) {
            if (this.isDrifting()) {
                for (int i = 0; i < 3; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, -this.field_70159_w * 4.0, 1.5, -this.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)state)});
                }
            } else {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, -this.field_70159_w * 4.0, 1.5, -this.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)state)});
            }
        }
        if (this.shouldShowEngineSmoke() && this.field_70173_aa % 2 == 0) {
            Vec3d smokePosition = this.getEngineSmokePosition().func_178785_b(-(this.field_70177_z - this.additionalYaw) * ((float)Math.PI / 180));
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + smokePosition.field_72450_a, this.field_70163_u + smokePosition.field_72448_b, this.field_70161_v + smokePosition.field_72449_c, -this.field_70159_w, 0.0, -this.field_70179_y, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientUpdate() {
        EntityLivingBase entity = (EntityLivingBase)this.func_184179_bs();
        if (entity != null && entity.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            AccelerationDirection acceleration = AccelerationDirection.fromEntity(entity);
            if (this.getAcceleration() != acceleration) {
                this.setAcceleration(acceleration);
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageAccelerating(acceleration));
            }
            boolean drifting = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
            if (this.isDrifting() != drifting) {
                this.setDrifting(drifting);
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageDrift(drifting));
            }
            boolean horn = ClientProxy.KEY_HORN.func_151470_d();
            this.setHorn(horn);
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageHorn(horn));
            TurnDirection direction = TurnDirection.FORWARD;
            if (entity.field_70702_br < 0.0f) {
                direction = TurnDirection.RIGHT;
            } else if (entity.field_70702_br > 0.0f) {
                direction = TurnDirection.LEFT;
            }
            if (this.getTurnDirection() != direction) {
                this.setTurnDirection(direction);
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTurn(direction));
            }
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !player.func_70093_af()) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (flag || this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    // empty if block
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public abstract double func_70042_X();

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("engineType", 3)) {
            this.setEngineType(EngineType.getType(compound.func_74762_e("engineType")));
        }
        if (compound.func_150297_b("maxSpeed", 5)) {
            this.setMaxSpeed(compound.func_74760_g("maxSpeed"));
        }
        if (compound.func_150297_b("accelerationSpeed", 5)) {
            this.setAccelerationSpeed(compound.func_74760_g("accelerationSpeed"));
        }
        if (compound.func_150297_b("turnSensitivity", 3)) {
            this.setTurnSensitivity(compound.func_74762_e("turnSensitivity"));
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("engineType", this.getEngineType().ordinal());
        compound.func_74776_a("maxSpeed", this.getMaxSpeed());
        compound.func_74776_a("accelerationSpeed", this.getAccelerationSpeed());
        compound.func_74768_a("turnSensitivity", this.getTurnSensitivity());
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        passenger.field_70177_z -= this.deltaYaw;
        passenger.func_70034_d(this.field_70177_z);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean isMoving() {
        return this.currentSpeed != 0.0f;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.field_70180_af.func_187227_b(MAX_SPEED, (Object)Float.valueOf(maxSpeed));
    }

    public float getMaxSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue();
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(CURRENT_SPEED, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return this.currentSpeed;
    }

    public float getNormalSpeed() {
        return this.currentSpeed / this.getMaxSpeed();
    }

    public float getAccelerationSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ACCELERATION_SPEED)).floatValue();
    }

    public void setAccelerationSpeed(float speed) {
        this.field_70180_af.func_187227_b(ACCELERATION_SPEED, (Object)Float.valueOf(speed));
    }

    public double getKilometersPreHour() {
        return Math.sqrt(Math.pow(this.field_70165_t - this.field_70169_q, 2.0) + Math.pow(this.field_70161_v - this.field_70166_s, 2.0)) * 20.0 * 3.6;
    }

    public void setTurnDirection(TurnDirection turnDirection) {
        this.field_70180_af.func_187227_b(TURN_DIRECTION, (Object)turnDirection.ordinal());
    }

    public TurnDirection getTurnDirection() {
        return TurnDirection.values()[(Integer)this.field_70180_af.func_187225_a(TURN_DIRECTION)];
    }

    public void setDrifting(boolean drifting) {
        this.field_70180_af.func_187227_b(DRIFTING, (Object)drifting);
    }

    public boolean isDrifting() {
        return (Boolean)this.field_70180_af.func_187225_a(DRIFTING);
    }

    public void setAcceleration(AccelerationDirection direction) {
        this.field_70180_af.func_187227_b(ACCELERATION_DIRECTION, (Object)direction.ordinal());
    }

    public AccelerationDirection getAcceleration() {
        return AccelerationDirection.values()[(Integer)this.field_70180_af.func_187225_a(ACCELERATION_DIRECTION)];
    }

    public void setTurnSensitivity(int sensitivity) {
        this.field_70180_af.func_187227_b(TURN_SENSITIVITY, (Object)sensitivity);
    }

    public int getTurnSensitivity() {
        return (Integer)this.field_70180_af.func_187225_a(TURN_SENSITIVITY);
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setEngineType(EngineType engineType) {
        this.field_70180_af.func_187227_b(ENGINE_TYPE, (Object)engineType.ordinal());
    }

    public EngineType getEngineType() {
        return EngineType.getType((Integer)this.field_70180_af.func_187225_a(ENGINE_TYPE));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderEngine() {
        return true;
    }

    public Vec3d getEngineSmokePosition() {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public boolean shouldShowEngineSmoke() {
        return false;
    }

    public void setHorn(boolean activated) {
        this.field_70180_af.func_187227_b(HORN, (Object)activated);
    }

    public boolean getHorn() {
        return (Boolean)this.field_70180_af.func_187225_a(HORN);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K && ENGINE_TYPE.equals(key)) {
            EngineType type = EngineType.getType((Integer)this.field_70180_af.func_187225_a(ENGINE_TYPE));
            this.engine.func_77964_b(type.ordinal());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.lerpYaw;
            this.field_70125_A = (float)this.lerpPitch;
        }
        if (passenger instanceof EntityPlayer && this.field_70170_p.field_72995_K) {
            VehicleMod.proxy.playVehicleSound((EntityPlayer)passenger, this);
        }
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (this.func_184179_bs() == null) {
            this.field_70177_z -= this.additionalYaw;
            this.additionalYaw = 0.0f;
        }
    }

    public static enum AccelerationDirection {
        FORWARD,
        NONE,
        REVERSE;


        public static AccelerationDirection fromEntity(EntityLivingBase entity) {
            if (entity.field_191988_bg > 0.0f) {
                return FORWARD;
            }
            if (entity.field_191988_bg < 0.0f) {
                return REVERSE;
            }
            return NONE;
        }
    }

    public static enum TurnDirection {
        LEFT(1),
        FORWARD(0),
        RIGHT(-1);

        final int dir;

        private TurnDirection(int dir) {
            this.dir = dir;
        }

        public int getDir() {
            return this.dir;
        }
    }
}

