/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.data.GlobalVariables;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFunctions {
    public static Boolean isHorse(Entity entity) {
        if (entity instanceof AbstractHorse) {
            return true;
        }
        return false;
    }

    public static boolean isModdedVillager(String entitystring) {
        String type = entitystring.split("\\[")[0];
        for (String moddedvillager : GlobalVariables.moddedvillagers) {
            if (!type.equalsIgnoreCase(moddedvillager)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModdedVillager(Entity entity) {
        String entitystring = EntityFunctions.getEntityString(entity);
        return EntityFunctions.isModdedVillager(entitystring);
    }

    public static boolean isMilkable(Entity entity) {
        if (entity instanceof EntitySheep || entity instanceof EntityLlama || entity instanceof EntityPig || entity instanceof EntityDonkey || entity instanceof EntityHorse || entity instanceof EntityMule) {
            if (!(entity instanceof EntityAnimal)) {
                return false;
            }
            EntityAnimal animal = (EntityAnimal)entity;
            return !animal.func_70631_g_();
        }
        return false;
    }

    public static String getEntityString(Entity entity) {
        String entitystring = "";
        try {
            entitystring = entity.toString();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return entitystring;
    }

    public static void nameEntity(Entity entity, String name) {
        if (name != "") {
            entity.func_96094_a(name);
        }
    }

    public static void addPotionEffect(Entity entity, Potion effect, Integer ms) {
        PotionEffect freeze = new PotionEffect(effect, ms / 50);
        EntityLiving le = (EntityLiving)entity;
        le.func_70690_d(freeze);
    }

    public static void removePotionEffect(Entity entity, Potion effect) {
        EntityLiving le = (EntityLiving)entity;
        le.func_184589_d(effect);
    }

    public static void chargeEntity(Entity entity) {
        World world = entity.func_130014_f_();
        Vec3d evec = entity.func_174791_d();
        EntityLightningBolt lightning = new EntityLightningBolt(world, evec.field_72450_a, evec.field_72448_b, evec.field_72449_c, true);
        lightning.func_184221_a(new UUID(0L, GlobalVariables.random.nextInt() * 1000000));
        entity.func_70077_a(lightning);
        entity.func_70066_B();
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to, boolean ignoremainhand) {
        if (!(from instanceof EntityMob)) {
            return;
        }
        EntityMob mobfrom = (EntityMob)from;
        for (EntityEquipmentSlot equipmentslottype : EntityEquipmentSlot.values()) {
            ItemStack itemstack;
            if (ignoremainhand && equipmentslottype.equals((Object)EntityEquipmentSlot.MAINHAND) || (itemstack = mobfrom.func_184582_a(equipmentslottype)).func_190926_b()) continue;
            to.func_184201_a(equipmentslottype, itemstack.func_77946_l());
        }
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to) {
        EntityFunctions.transferItemsBetweenEntities(from, to, false);
    }

    public static Boolean doesEntitySurviveThisDamage(EntityPlayer player, int halfheartdamage) {
        return EntityFunctions.doesEntitySurviveThisDamage((EntityLivingBase)player, halfheartdamage);
    }

    public static Boolean doesEntitySurviveThisDamage(EntityLivingBase entity, int halfheartdamage) {
        float newhealth = entity.func_110143_aJ() - (float)halfheartdamage;
        if (!(newhealth > 0.0f)) {
            entity.func_70097_a(DamageSource.field_76376_m, Float.MAX_VALUE);
            return false;
        }
        entity.func_70097_a(DamageSource.field_76376_m, 0.1f);
        entity.func_70606_j(newhealth);
        return true;
    }
}

