/*******************************************************************
 $CRT 29 Sep 2006 : hb

 $DAT >>Vegas_MtPv_Filter.js<< 03 Oct 2006  11:34:46 - (c) proDAD
*******************************************************************/

import System.Windows.Forms;
import Microsoft.Win32;
import Sony.Vegas;


StopPlayback();


var TC  : Timecode   = Vegas.Cursor;
var Evt : TrackEvent = FindSelectedEvent();

if(Evt != null)
{
  if(TC <= Evt.Start)
  {
    TC = Evt.Start;
    TC.FrameCount += 1;
  }
  else
  {
    TC.FrameCount += 2;
    if(TC >= Evt.End)
    {
      TC = Evt.Start;
      TC.FrameCount += 1;
    }
  }

  Vegas.Cursor = TC;

  SavePrjInfo();
  SaveDuration(Evt.Length);
}




/*----------------------------------
----------------------------------*/
function FindSelectedEvent() : TrackEvent
{
  var trackEnum = new Enumerator(Vegas.Project.Tracks);
  while(!trackEnum.atEnd())
  {
    var track : Track = Track(trackEnum.item());
    if(track.Selected)
    {
      var eventEnum = new Enumerator(track.Events);
      while(!eventEnum.atEnd())
      {
        var evnt : TrackEvent = TrackEvent(eventEnum.item());
        if(evnt.Selected)
        {
          return evnt;
        }
        eventEnum.moveNext();
      }
    }
    trackEnum.moveNext();
  }
  return null;
}


/*----------------------------------
----------------------------------*/
function GetMediaStream(trackEvent : TrackEvent)
{
  if( !trackEvent.ActiveTake.IsValid())
  {
    return null;
  }

  var Media = Vegas.Project.MediaPool.Find
  (
    trackEvent.ActiveTake.MediaPath
  );
  if(null == Media)
  {
    return null;
  }

  var MediaStream = Media.Streams.GetItemByMediaType
  (
    MediaType.Video,
    trackEvent.ActiveTake.StreamIndex
  );

  return MediaStream;
}


/*----------------------------------
----------------------------------*/
function GetRegTopKey()
{
  var rk = Registry.CurrentUser;
  rk = rk.CreateSubKey("Software");
  rk = rk.CreateSubKey("proDAD");
  rk = rk.CreateSubKey("tmp");
  rk = rk.CreateSubKey("Vegas");
  return rk;
}


/*----------------------------------
----------------------------------*/
function SaveDuration(tc : Timecode)
{
  var rk = GetRegTopKey();
  rk.SetValue
  (
    "duration",
    tc.ToMilliseconds()
  );
}


/*----------------------------------
----------------------------------*/
function SavePrjInfo()
{
  var rk = GetRegTopKey();

  rk.SetValue
  (
    "width",
    Vegas.Project.Video.Width.ToString()
  );

  rk.SetValue
  (
    "height",
    Vegas.Project.Video.Height.ToString()
  );

  rk.SetValue
  (
    "aspect",
    Math.round(10000*Vegas.Project.Video.PixelAspectRatio).ToString()
  );

  rk.SetValue
  (
    "fps",
    Math.round(10000*Vegas.Project.Video.FrameRate).ToString()
  );

  /*
    var MediaStream = GetMediaStream(trackEvent);
    if(MediaStream)
    {
      var VideoStream = VideoStream(MediaStream);
      var MediaPixelAspect = VideoStream.PixelAspectRatio;
    }
  */


}


/*----------------------------------
 Don't work ?!
----------------------------------*/
function StopPlayback()
{
  var WshShell = new ActiveXObject("WScript.Shell");
  WshShell.SendKeys("{ESC}");
}
