HODCALLTYPE GetSecuritySite( 
            /* [out] */ IInternetSecurityMgrSite **ppSite) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE MapUrlToZone( 
            /* [in] */ LPCWSTR pwszUrl,
            /* [out] */ DWORD *pdwZone,
            /* [in] */ DWORD dwFlags) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE GetSecurityId( 
            /* [in] */ LPCWSTR pwszUrl,
            /* [size_is][out] */ BYTE *pbSecurityId,
            /* [out][in] */ DWORD *pcbSecurityId,
            /* [in] */ DWORD_PTR dwReserved) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE ProcessUrlAction( 
            /* [in] */ LPCWSTR pwszUrl,
            /* [in] */ DWORD dwAction,
            /* [size_is][out] */ BYTE *pPolicy,
            /* [in] */ DWORD cbPolicy,
            /* [in] */ BYTE *pContext,
            /* [in] */ DWORD cbContext,
            /* [in] */ DWORD dwFlags,
            /* [in] */ DWORD dwReserved) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE QueryCustomPolicy( 
            /* [in] */ LPCWSTR pwszUrl,
            /* [in] */ REFGUID guidKey,
            /* [size_is][size_is][out] */ BYTE **ppPolicy,
            /* [out] */ DWORD *pcbPolicy,
            /* [in] */ BYTE *pContext,
            /* [in] */ DWORD cbContext,
            /* [in] */ DWORD dwReserved) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE SetZoneMapping( 
            /* [in] */ DWORD dwZone,
            /* [in] */ LPCWSTR lpszPattern,
            /* [in] */ DWORD dwFlags) = 0;
        
        virtual HRESULT STDMETHODCALLTYPE GetZoneMappings( 
            /* [in] */ DWORD dwZone,
            /* [out] */ IEnumString **ppenumString,
            /* [in] */ DWORD dwFlags) = 0;
        
    };
    
#else 	/* C style interface */

    typedef struct IInternetSecurityManagerVtbl
    {
        BEGIN_INTERFACE
        
        HRESULT ( STDMETHODCALLTYPE *QueryInterface )( 
            IInternetSecurityManager * This,
            /* [in] */ REFIID riid,
            /* [iid_is][out] */ void **ppvObject);
        
        ULONG ( STDMETHODCALLTYPE *AddRef )( 
            IInternetSecurityManager * This);
        
        ULONG ( STDMETHODCALLTYPE *Release )( 
            IInternetSecurityManager * This);
        
        HRESULT ( STDMETHODCALLTYPE *SetSecuritySite )( 
            IInternetSecurityManager * This,
            /* [unique][in] */ IInternetSecurityMgrSite *pSite);
        
        HRESULT ( STDMETHODCALLTYPE *GetSecuritySite )( 
            IInternetSecurityManager * This,
            /* [out] */ IInternetSecurityMgrSite **ppSite);
        
