( STDMETHODCALLTYPE *SetZoneMapping )( 
            IInternetSecurityManager * This,
            /* [in] */ DWORD dwZone,
            /* [in] */ LPCWSTR lpszPattern,
            /* [in] */ DWORD dwFlags);
        
        HRESULT ( STDMETHODCALLTYPE *GetZoneMappings )( 
            IInternetSecurityManager * This,
            /* [in] */ DWORD dwZone,
            /* [out] */ IEnumString **ppenumString,
            /* [in] */ DWORD dwFlags);
        
        END_INTERFACE
    } IInternetSecurityManagerVtbl;

    interface IInternetSecurityManager
    {
        CONST_VTBL struct IInternetSecurityManagerVtbl *lpVtbl;
    };

    

#ifdef COBJMACROS


#define IInternetSecurityManager_QueryInterface(This,riid,ppvObject)	\
    (This)->lpVtbl -> QueryInterface(This,riid,ppvObject)

#define IInternetSecurityManager_AddRef(This)	\
    (This)->lpVtbl -> AddRef(This)

#define IInternetSecurityManager_Release(This)	\
    (This)->lpVtbl -> Release(This)


#define IInternetSecurityManager_SetSecuritySite(This,pSite)	\
    (This)->lpVtbl -> SetSecuritySite(This,pSite)

#define IInternetSecurityManager_GetSecuritySite(This,ppSite)	\
    (This)->lpVtbl -> GetSecuritySite(This,ppSite)

#define IInternetSecurityManager_MapUrlToZone(This,pwszUrl,pdwZone,dwFlags)	\
    (This)->lpVtbl -> MapUrlToZone(This,pwszUrl,pdwZone,dwFlags)

#define IInternetSecurityManager_GetSecurityId(This,pwszUrl,pbSecurityId,pcbSecurityId,dwReserved)	\
    (This)->lpVtbl -> GetSecurityId(This,pwszUrl,pbSecurityId,pcbSecurityId,dwReserved)

#define IInternetSecurityManager_ProcessUrlAction(This,pwszUrl,dwAction,pPolicy,cbPolicy,pContext,cbContext,dwFlags,dwReserved)	\
    (This)->lpVtbl -> ProcessUrlAction(This,pwszUrl,dwAction,pPolicy,cbPolicy,pContext,cbContext,dwFlags,dwReserved)

#define IInternetSecurityManager_QueryCustomPolicy(This,pwszUrl,guidKey,ppPolicy,pcbPolicy,pContext,cbContext,dwReserved)	\
    (This)->lpVtbl -> QueryCustomPolicy(This,pwszUrl,guidKey,ppPolicy,pcbPolicy,pContext,cbContext,dwReserved)

#define IInternetSecurityManager_SetZoneMapping(This,dwZone,lpszPattern,dwFlags)	\
    (This)->lpVtbl -> SetZoneMapping(This,dwZone,lpszPattern,dwFlags)

#define IInternetSecurityManager_GetZoneMappings(This,dwZone,ppenumString,dwFlags)	\
    (This)->lpVtbl -> GetZoneMappings(This,dwZone,ppenumString,dwFlags)

#endif /* COBJMACROS */


#endif 	/* C style interface */



HRESULT STDMETHODCALLTYPE IInternetSecurityManager_SetSecuritySite_Proxy( 
    IInternetSecurityManager * This,
    /* [unique][in] */ IInternetSecurityMgrSite *pSite);


void __RPC_STUB IInternetSecurityManager_SetSecuritySite_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


HRESULT STDMETHODCALLTYPE IInternetSecurityManager_GetSecuritySite_Proxy( 
    IInternetSecurityManager * This,
    /* [out] */ IInternetSecurityMgrSite **ppSite);


void __RPC_STUB IInternetSecurityManager_GetSecuritySite_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


HRESULT STDMETHODCALLTYPE IInternetSecurityManager_MapUrlToZone_Proxy( 
    IInternetSecurityManager * This,
    /* [in] */ LPCWSTR pwszUrl,
    /* [out] */ DWORD *pdwZone,
    /* [in] */ DWORD dwFlags);


void __RPC_STUB IInternetSecurityManager_MapUrlToZone_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


HRESULT STDMETHODCALLTYPE IInternetSecurityManager_GetSecurityId_Proxy( 
    IInternetSecurityManager * This,
    /* [in] */ LPCWSTR pwszUrl,
    /* [size_is][out] */ BYTE *pbSecurityId,
    /* [out][in] */ DWORD *pcbSecurityId,
    /* [in] */ DWORD_PTR dwReserved);


void __RPC_STUB IInternetSecurityManager_GetSecurityId_Stub(
    IRpcStubBuffer *This,
    IRpcChannelBuffer *_pRpcChannelBuffer,
    PRPC_MESSAGE _pRpcMessage,
    DWORD *_pdwStubPhase);


HRESULT STDMETHODCALLTYPE IInternetSecurityManager_ProcessUrlAction_Proxy( 
    IInternetSecurityManager * This,
    /* [in] */ LPCWSTR pwszUrl,
    /* [in] */ DWORD dwAction,
    /* [size