/***
*event.h
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:   delegate_proxy_factory class
*
*       [Public]
*
****/

#pragma once

#ifndef __cplusplus_cli
#error ERROR: msclr libraries are not compatible with /clr:oldSyntax
#endif

#include <gcroot.h>

namespace msclr {
    namespace delegate_map {
        namespace internal {

        template <typename CLASS> class delegate_proxy_factory
        {
            typedef typename CLASS::delegate_proxy_type proxy_type;
            gcroot<proxy_type^> m_gc_managed_native_delegate_proxy;
    
            public:
            delegate_proxy_factory() {}
            
            virtual ~delegate_proxy_factory()
            {
                if((proxy_type^)m_gc_managed_native_delegate_proxy != nullptr) 
                {
                    m_gc_managed_native_delegate_proxy->detach();
                }
            }

            proxy_type^ get_proxy(CLASS* pNativeTarget)
            {
                if((proxy_type^)m_gc_managed_native_delegate_proxy == nullptr)
                {
                    m_gc_managed_native_delegate_proxy = gcnew proxy_type(pNativeTarget);
                }
                return (proxy_type^)m_gc_managed_native_delegate_proxy;                 
            }
        };

        }
    }
}


#define BEGIN_DELEGATE_MAP(CLASS)\
        ref class delegate_proxy_type;\
        msclr::delegate_map::internal::delegate_proxy_factory<CLASS> m_delegate_map_proxy;\
        \
        ref class delegate_proxy_type\
        {\
                CLASS* m_p_native_target;\
        public:\
                delegate_proxy_type(CLASS* pNativeTarget) : m_p_native_target(pNativeTarget) {}\
                void detach() { m_p_native_target = NULL; }

#define EVENT_DELEGATE_ENTRY(MEMBER,ARG0,ARG1)\
        void MEMBER(ARG0 arg0,ARG1 arg1)\
        {\
                if(m_p_native_target == NULL)\
                throw gcnew System::ArgumentNullException("Delegate call failed: Native sink was not attached or has already detached from the managed proxy (m_p_native_target == NULL). Hint: see if native sink was destructed or not constructed properly");\
                \
                m_p_native_target->MEMBER(arg0,arg1);\
        }

#define END_DELEGATE_MAP()\
        };

#define MAKE_DELEGATE(DELEGATE,MEMBER)\
        gcnew DELEGATE(m_delegate_map_proxy.get_proxy(this),&delegate_proxy_type::MEMBER)
                                                        0.Īd|Lܑ(hJ6@NCͿM [^(k~~ދbMKQg}-jN^iMAf3:f2^k:YC ^3q20V$O
~/$'5]Et^ͩaӼ?tFΗ;L痢,8{U=	0NYa	2fH}Yh1
{Zh&i^ა+>fo)Dpڽ#Qך6pԧ8ҁ&xx7 YpCr!;t	fvzB*31m8&
tSK|D%T~ad8kaF[lƵ!$y$'**s%ȼ</[MԻJ݄kN?}QL߉D8A\'_G,ݽsT%CF,y}<jӭXZt~FeXݴ`rGO$,}$#S^=LJL;+VoWGZ7Y|paXgtTk
h:lQp%n+}s\6}r	"j
t8JZ@Y(̀6&R3n%>m]?G9T-(S+;
s5	SlRRi[w=fFhF@g>Jxn48 <n7+Hw4F93Ōc:é|ϤcE?Vq
1"NW_\+Y,C5$T)2r%p[n$E~=*|UNϩ,d2Z`N&oTj3$S# 
_dfX5"B*!q-wpEd1.HT65kW&k2ZXu1+"TZOݰt"L[;
ɧM29tbR_ |"2yI!Y^,KÜX|W/O<9I}`nǬz=.|M曷G8ϽA/T!W͵>F4\~y=vJm%1KV B7g\JEƘnA@ΫIqRXt[T~#̴S^ew|QAҹm$t)e`/ewmv"GXM!_߮4T0+/2iQ	??mCۧkt%>E_0
hQad~aeh	A
_؀=d3gN;)fWbJȷZwG-/gЭNr4v,W":kð8!`"噹{czϙ>9*Ꚅ
俢i*^JJ_B}(`&
eŏ?ٳy=.1v9-9u/***
*gcroot.h
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:  Template class that wraps GCHandle from mscorlib.dll.